/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Map;
import org.joda.time.LocalDate;

public class PropertyHandler {
    public static Object getValue(final Map.Entry<String, String> property) {
        switch (property.getKey()) {
            case "airlineNumber": 
            case "kpp": 
            case "registrationId": 
            case "timeZoneId": {
                return property.getValue();
            }
            case "country": {
                return new DictionaryReference<Country>(){

                    public Class<Country> getType() {
                        return Country.class;
                    }

                    public String getCode() {
                        return (String)property.getValue();
                    }
                };
            }
            case "type": {
                return PropertyHandler.getType(property.getValue());
            }
            case "openDate": 
            case "closeDate": {
                return LocalDate.parse((String)property.getValue()).toDate();
            }
            case "alliance": {
                return new DictionaryReference<AirlineAlliance>(){

                    public Class<AirlineAlliance> getType() {
                        return AirlineAlliance.class;
                    }

                    public String getCode() {
                        return (String)property.getValue();
                    }
                };
            }
            case "parent": {
                return new DictionaryReference<GeoLocation>(){

                    public Class<GeoLocation> getType() {
                        return GeoLocation.class;
                    }

                    public String getCode() {
                        return (String)property.getValue();
                    }
                };
            }
            case "vendorCards": {
                return RailwayStationVendorCardType.valueOf((String)property.getValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Object getType(String propertyValue) {
        switch (propertyValue) {
            case "city": {
                return LocationType.CITY;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isEmpty(Map.Entry<String, String> property) {
        return TextUtil.isBlank((String)property.getValue()) || TextUtil.isBlank((String)property.getKey());
    }
}

