/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.model.booking.statistics.RedAppCounterItem;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.RedAppRestHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import org.jibx.ws.soap.SoapFaultException;

public class RedAppCounterAdvice
extends BaseAdvice {
    private static final List<Class<? extends Throwable>> FAULT_CLASSES = Arrays.asList(SoapFaultException.class, SOAPFaultException.class);

    public void before(MessageContext ctx) throws Exception {
        String redappLogin = (String)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_LOGIN);
        List lateRequests = (List)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_COUNTER_ITEMS_TO_SAVE_LATER);
        if (TextUtil.isBlank((String)redappLogin) && lateRequests == null) {
            return;
        }
        if (!AppConfiguration.get().isRedAppCounterEnabled()) {
            return;
        }
        RestContext context = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        RedAppCounterItem redAppCounterItem = new RedAppCounterItem();
        redAppCounterItem.setRestMethod(context.getRequest().getMethod() + " " + context.getRequest().getPathInfo());
        redAppCounterItem.setRestLogin(redappLogin);
        redAppCounterItem.setSabrePcc((String)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_PCC));
        redAppCounterItem.setSabreAgentSign((String)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_AGENT_SIGN));
        redAppCounterItem.setSabreAction((String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE));
        redAppCounterItem.setSabreDate(new Date());
        if (lateRequests != null) {
            lateRequests.add(redAppCounterItem);
        }
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_COUNTER_ITEM, (Object)redAppCounterItem);
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        RedAppCounterItem redAppCounterItem = (RedAppCounterItem)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_COUNTER_ITEM);
        if (redAppCounterItem != null) {
            boolean noResponse;
            Object resp = ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
            boolean bl = noResponse = resp == null;
            if (noResponse) {
                redAppCounterItem.setFailed(true);
                boolean isFault = FAULT_CLASSES.stream().anyMatch(f -> f.isAssignableFrom(e.getClass()));
                if (isFault) {
                    redAppCounterItem.setSoapFault(true);
                } else {
                    redAppCounterItem.setExceptionName(ExceptionUtil.findCause((Throwable)e).getClass().getName());
                }
            }
        }
        return false;
    }

    public void after(MessageContext ctx) throws Exception {
        RedAppCounterItem redAppCounterItem = (RedAppCounterItem)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_COUNTER_ITEM);
        List lateItems = (List)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_COUNTER_ITEMS_TO_SAVE_LATER);
        if (redAppCounterItem != null && lateItems == null) {
            RedAppRestHelper.asyncSaveData(redAppCounterItem);
        }
    }
}

