/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptor;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.BaseParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedirectLoggingData;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedAppRedirectLoggingInterceptor
implements GenericRestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RedAppRedirectLoggingInterceptor.class);

    public void before(RestContext context, Map<String, Object> data) throws Exception {
        BaseParameters parameters = (BaseParameters)data.get(IBusRestContextKeys.REST_PARAMS.name());
        RedirectLoggingData redirectedData = parameters.getRedirectLoggingData();
        if (redirectedData != null) {
            LOG.info(String.format("Redapp user (PCC=%s, ERP=%s, Agency=%s, MOM=%s) was redirected during %s request", redirectedData.getPcc(), redirectedData.getErp(), redirectedData.getAgencyName(), redirectedData.getMomUrl(), redirectedData.getPathId()));
        }
    }

    public boolean handleException(RestContext context, Map<String, Object> data, Throwable exception) throws Exception {
        return false;
    }

    public void after(RestContext context, Map<String, Object> data) throws Exception {
    }
}

