/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.statistics.RedAppCounterItem;
import com.gridnine.xtrip.server.web.rest.redapp.assets.SendRedAppCounter;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedAppRestHelper {
    private static final Logger log = LoggerFactory.getLogger(RedAppRestHelper.class);

    public static void asyncSaveData(RedAppCounterItem redAppCounterItem) {
        AsyncExecutor.get().execute("redapp-counter", (AsyncCommand & Serializable)() -> RedAppRestHelper.saveData(redAppCounterItem), new AsyncCommandOption[]{AsyncCommandOption.LOCAL});
    }

    private static void saveData(RedAppCounterItem redAppCounterItem) {
        try {
            SendRedAppCounter counter = new SendRedAppCounter();
            counter.setModified(new Date());
            counter.setOperationAppUid(redAppCounterItem.getUid());
            counter.setRestMethod(redAppCounterItem.getRestMethod());
            counter.setRestLogin(redAppCounterItem.getRestLogin());
            counter.setSabrePcc(redAppCounterItem.getSabrePcc());
            counter.setSabreAgentSign(redAppCounterItem.getSabreAgentSign());
            counter.setSabreAction(redAppCounterItem.getSabreAction());
            counter.setSabreDate(redAppCounterItem.getSabreDate());
            counter.setFailed(redAppCounterItem.isFailed());
            counter.setSoapFault(redAppCounterItem.isSoapFault());
            counter.setExceptionName(redAppCounterItem.getExceptionName());
            AssetsStorage.get().save((BaseAsset)counter);
        }
        catch (Exception e) {
            log.error("failed save redApp data " + RedAppRestHelper.getRequestInfo(redAppCounterItem), (Throwable)e);
            throw Xeption.forDeveloper((String)"save redApp counter data failed", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static RedAppCounterItem toRedAppCounterItem(SendRedAppCounter counter) {
        RedAppCounterItem result = new RedAppCounterItem(counter.getOperationAppUid());
        result.setRestMethod(counter.getRestMethod());
        result.setRestLogin(counter.getRestLogin());
        result.setSabrePcc(counter.getSabrePcc());
        result.setSabreAgentSign(counter.getSabreAgentSign());
        result.setSabreAction(counter.getSabreAction());
        result.setSabreDate(counter.getSabreDate());
        result.setFailed(counter.isFailed());
        result.setSoapFault(counter.isSoapFault());
        result.setExceptionName(counter.getExceptionName());
        return result;
    }

    private static String getRequestInfo(RedAppCounterItem redAppCounterItem) {
        return String.join((CharSequence)",", redAppCounterItem.getRestMethod(), redAppCounterItem.getRestLogin(), redAppCounterItem.getSabrePcc(), redAppCounterItem.getSabreAgentSign(), redAppCounterItem.getSabreAction(), String.valueOf(redAppCounterItem.isFailed()));
    }
}

