/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.RedAppSettings;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.web.rest.redapp.service.CwtSchemeHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.GetSegmentsData;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CodeSystem;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CodeSystemValue;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.Communication;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.EmailType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.EntityType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.Gender;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ImportDataDetails;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.KeyContact;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.LocalizableValue;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestAgentsOrganization;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestAirExchangedTicket;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestAirSegment;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestAirTicket;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestAircraft;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestAirline;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestBooking;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestCancellationData;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestCarType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestCommunicationType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestCompartment;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestCountry;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestCurrency;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestGeoLocation;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestHolding;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestHotel;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestHotelRoom;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestHotelSegment;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestHotelTicket;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestNightDetails;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestOrganization;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestOrganizationType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestPerson;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestPrice;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailSegment;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailTicket;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailTravellerData;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailwayCarrier;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailwayStation;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRedAppSettings;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestReference;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRoomSize;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestTax;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestTraveller;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestTravellerData;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.SabreLineType;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestConverter {
    private static final ThreadLocal<SimpleDateFormat> DATA_STANDARD_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("YYYY-MM-dd'T'HH:mm:ss"));

    public static RestReference convertReference2Rest(EntityReference<?> entityReference) {
        if (entityReference == null) {
            return null;
        }
        RestReference restReference = new RestReference();
        restReference.setUid(entityReference.getUid());
        restReference.setName(entityReference.toString());
        restReference.setEntityType(RestConverter.getType(MiscUtil.getSimpleClassName((Class)entityReference.getType())));
        return restReference;
    }

    public static RestReference convertDictReference2Rest(DictionaryReference<?> entityReference) {
        if (entityReference == null) {
            return null;
        }
        RestReference restReference = new RestReference();
        restReference.setUid(entityReference.getCode());
        restReference.setName(entityReference.toString(Locale.ENGLISH));
        restReference.setEntityType(RestConverter.getType(MiscUtil.getSimpleClassName((Class)entityReference.getType())));
        return restReference;
    }

    private static EntityType getType(String simpleClassName) {
        String className;
        switch (simpleClassName) {
            case "CurrencyInfo": {
                className = "Currency";
                break;
            }
            case "RoomSizeDict": {
                className = "RoomType";
                break;
            }
            default: {
                className = simpleClassName;
            }
        }
        return EntityType.valueOf((String)className);
    }

    public static RestOrganization convertOrganization2Rest(EntityContainer<Organization> container) {
        if (container == null) {
            return null;
        }
        Organization org = (Organization)container.getEntity();
        RestOrganization organization = new RestOrganization();
        String fullName = L10nStringHelper.getValue((L10nString)org.getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        organization.setName(fullName);
        organization.setCode(org.getCode());
        organization.setUid(container.getUid());
        organization.setPreferredLanguage(org.getPreferredLocale() != null ? org.getPreferredLocale().getLanguage() : null);
        org.getKeyContacts().stream().map(RestConverter::convertKeyContactToRest).collect(Collectors.toCollection(() -> ((RestOrganization)organization).getKeyContacts()));
        organization.setHolding(RestConverter.convertReference2Rest(org.getHolding()));
        organization.getType().addAll(org.getTypes().stream().map(t -> RestOrganizationType.valueOf((String)t.name())).collect(Collectors.toList()));
        organization.getBookingPccs().addAll(org.getBookingPccs());
        return organization;
    }

    public static RestAgentsOrganization convertAgentsOrganizationToRest(EntityContainer<Organization> container) {
        Organization org = (Organization)container.getEntity();
        RestAgentsOrganization result = new RestAgentsOrganization();
        String fullName = L10nStringHelper.getValue((L10nString)org.getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        result.setName(fullName);
        result.setUid(container.getUid());
        result.setRedAppSettings(RestConverter.convertRedAppSettingsToRest(org.getRedappSettings()));
        result.getBookingPccs().addAll(org.getBookingPccs());
        return result;
    }

    private static RestRedAppSettings convertRedAppSettingsToRest(RedAppSettings redappSettings) {
        RestRedAppSettings result = new RestRedAppSettings();
        result.setLicenseKey(redappSettings.getLicenseKey());
        return null;
    }

    private static KeyContact convertKeyContactToRest(ProfileKeyContactPerson kk) {
        KeyContact keyContact = new KeyContact();
        keyContact.setEmailType((EmailType)Optional.ofNullable(kk.getEmailType()).map(Enum::name).map(EmailType::valueOf).orElse(null));
        keyContact.setPerson(RestConverter.convertReference2Rest(kk.getPerson()));
        Optional.ofNullable(kk.getLineType()).map(Enum::name).map(SabreLineType::valueOf).ifPresent(arg_0 -> ((KeyContact)keyContact).setSabreLineType(arg_0));
        Person perCont = Optional.ofNullable(EntityStorage.get().resolve(kk.getPerson())).map(EntityContainer::getEntity).orElse(null);
        if (perCont != null) {
            for (PersonCommunication communication : perCont.getCommunications()) {
                if (communication == null || TextUtil.isBlank((String)communication.getSense()) || communication.getType() == null) continue;
                if ((communication.getType() == CommunicationType.MOBILE || communication.getType() == CommunicationType.WORK_PHONE) && keyContact.getOrganizationContacts().stream().noneMatch(c -> c.getType() == RestCommunicationType.MOBILE || c.getType() == RestCommunicationType.WORK_PHONE)) {
                    keyContact.getOrganizationContacts().add(RestConverter.convertCommunication(communication));
                }
                if (communication.getType() != CommunicationType.EMAIL || !keyContact.getOrganizationContacts().stream().noneMatch(c -> c.getType() == RestCommunicationType.EMAIL)) continue;
                keyContact.getOrganizationContacts().add(RestConverter.convertCommunication(communication));
            }
        }
        return keyContact;
    }

    private static <E1 extends Enum<E1>, E2 extends Enum<E2>> E2 enum2enum(E1 enumSource, Class<E2> resultEnumClass) {
        String key = Optional.ofNullable(enumSource).map(Enum::name).orElse(null);
        return key == null ? null : (E2)Enum.valueOf(resultEnumClass, key);
    }

    public static RestPerson convertPerson2Rest(EntityContainer<Person> container) {
        if (container == null) {
            return null;
        }
        Person person = (Person)container.getEntity();
        RestPerson restPerson = new RestPerson();
        restPerson.setUid(container.getUid());
        restPerson.setFirstName((String)MiscUtil.findByLocale((Map)person.getFirstName().getValues(), (Locale)LocaleHelper.getCurrentLocale()));
        restPerson.setLastName((String)MiscUtil.findByLocale((Map)person.getLastName().getValues(), (Locale)LocaleHelper.getCurrentLocale()));
        restPerson.setFirstNameEn((String)MiscUtil.findByLocale((Map)person.getFirstName().getValues(), (Locale)LocaleHelper.EN_LOCALE));
        restPerson.setLastNameEn((String)MiscUtil.findByLocale((Map)person.getLastName().getValues(), (Locale)LocaleHelper.EN_LOCALE));
        restPerson.setPreferredLanguage(person.getPreferredLocale() != null ? person.getPreferredLocale().getLanguage() : null);
        person.getCommunications().stream().map(RestConverter::convertCommunication).collect(Collectors.toCollection(() -> ((RestPerson)restPerson).getCommunications()));
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.keyContacts.name(), (Object)container.getUid())}));
        EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(OrganizationIndex::getSource).map(RestConverter::convertReference2Rest).collect(Collectors.toCollection(() -> ((RestPerson)restPerson).getKeyContactOf()));
        return restPerson;
    }

    private static Communication convertCommunication(PersonCommunication pc) {
        Communication communication = new Communication();
        switch (pc.getType()) {
            case EMAIL: {
                communication.setType(RestCommunicationType.EMAIL);
                communication.setValue(pc.getSense());
                break;
            }
            case WEB: {
                break;
            }
            default: {
                communication.setType((RestCommunicationType)Optional.ofNullable(pc.getType()).map(Enum::name).map(RestCommunicationType::valueOf).orElse(null));
                communication.setValue(pc.getSense());
                communication.setCountryCode(pc.getCountryCode());
                communication.setCityCode(pc.getCityCode());
            }
        }
        return communication;
    }

    public static RestHolding convertHolding2Rest(EntityContainer<Holding> cont) {
        if (cont == null) {
            return null;
        }
        RestHolding restHolding = new RestHolding();
        Holding holding = (Holding)cont.getEntity();
        String fullName = L10nStringHelper.getValue((L10nString)holding.getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        restHolding.setName(fullName);
        restHolding.setCode(holding.getCode());
        restHolding.setUid(cont.getUid());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.holding.name(), (Object)cont.toReference())}));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name())}));
        EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(EntityIndex::getSource).map(RestConverter::convertReference2Rest).collect(Collectors.toCollection(() -> ((RestHolding)restHolding).getClients()));
        return restHolding;
    }

    public static RestAirline convertAirline2Rest(Airline airline) {
        if (airline == null) {
            return null;
        }
        RestAirline restAirline = new RestAirline();
        restAirline.setUid(airline.getCode());
        restAirline.setNumber(airline.getAirlineNumber());
        restAirline.setName(RestConverter.convertTranslations2Rest(airline.getTranslations()));
        restAirline.setCode(RestConverter.convertCodes2Rest(airline.getCodeVariants()));
        return restAirline;
    }

    public static RestGeoLocation convertGeoLocation2Rest(GeoLocation geoLocation) {
        if (geoLocation == null) {
            return null;
        }
        RestGeoLocation restGeoLocation = new RestGeoLocation();
        restGeoLocation.setUid(geoLocation.getCode());
        restGeoLocation.setName(RestConverter.convertTranslations2Rest(geoLocation.getTranslations()));
        restGeoLocation.setCode(RestConverter.convertCodes2Rest(geoLocation.getCodeVariants()));
        restGeoLocation.setCountry(RestConverter.convertDictReference2Rest(geoLocation.getCountry()));
        restGeoLocation.setOwner(RestConverter.convertDictReference2Rest(geoLocation.getParent()));
        return restGeoLocation;
    }

    public static RestCountry convertCountry2Rest(Country country) {
        if (country == null) {
            return null;
        }
        RestCountry restCountry = new RestCountry();
        restCountry.setUid(country.getCode());
        restCountry.setDomestic(country.isDomestic());
        restCountry.setName(RestConverter.convertTranslations2Rest(country.getTranslations()));
        restCountry.setCode(RestConverter.convertCodes2Rest(country.getCodeVariants()));
        return restCountry;
    }

    private static LocalizableValue convertTranslations2Rest(Map<Locale, String> translations) {
        String enName;
        LocalizableValue localizableValue = new LocalizableValue();
        String ruName = (String)MiscUtil.findByLocale(translations, (Locale)LocaleHelper.RU_LOCALE);
        if (TextUtil.nonBlank((String)ruName)) {
            localizableValue.getLocale().put("ru", ruName);
        }
        if (TextUtil.nonBlank((String)(enName = (String)MiscUtil.findByLocale(translations, (Locale)LocaleHelper.EN_LOCALE)))) {
            localizableValue.getLocale().put("en", enName);
        }
        return localizableValue;
    }

    private static CodeSystemValue convertCodes2Rest(Map<String, String> codeVariants) {
        String crtCode;
        CodeSystemValue result = new CodeSystemValue();
        String iataCode = codeVariants.get(CodeSystem.IATA.name());
        if (TextUtil.nonBlank((String)iataCode)) {
            result.getCode().put(CodeSystem.IATA, iataCode);
        }
        if (TextUtil.nonBlank((String)(crtCode = codeVariants.get(CodeSystem.CRT.name())))) {
            result.getCode().put(CodeSystem.CRT, crtCode);
        }
        return result;
    }

    public static RestRailwayStation convertRailwayStation2Rest(RailwayStation railwayStation) {
        if (railwayStation == null) {
            return null;
        }
        RestRailwayStation restRailwayStation = new RestRailwayStation();
        restRailwayStation.setUid(railwayStation.getCode());
        restRailwayStation.setName(RestConverter.convertTranslations2Rest(railwayStation.getTranslations()));
        return restRailwayStation;
    }

    public static RestRailwayStation convertRailwayStationByCard2Rest(RailwayStation railwayStation, RailwayStationVendorCardType type) {
        if (railwayStation == null) {
            return null;
        }
        RestRailwayStation restRailwayStation = RestConverter.convertRailwayStation2Rest(railwayStation);
        RailwayStationVendorCard card = railwayStation.getVendorCards().stream().filter(c -> c.getType() == type).findFirst().orElse(null);
        if (card != null) {
            LocalizableValue localizableValue = RestConverter.convertTranslations2Rest(card.getTranslations().getValues());
            restRailwayStation.setName(localizableValue);
            com.gridnine.xtrip.common.model.dict.CodeSystem codeSystem = RestConverter.getTargetCodeSystem(type);
            if (codeSystem != null) {
                String code = (String)railwayStation.getCodeVariants().get(codeSystem.name());
                restRailwayStation.setCode(code);
            }
        }
        return restRailwayStation;
    }

    private static com.gridnine.xtrip.common.model.dict.CodeSystem getTargetCodeSystem(RailwayStationVendorCardType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case UZ: {
                return com.gridnine.xtrip.common.model.dict.CodeSystem.EXPRESS_UZ;
            }
            case RZD: {
                return com.gridnine.xtrip.common.model.dict.CodeSystem.EXPRESS;
            }
        }
        return null;
    }

    public static RestRailwayCarrier convertRailwayCarrier2Rest(RailwayCarrier railwayCarrier) {
        if (railwayCarrier == null) {
            return null;
        }
        RestRailwayCarrier restRailwayCarrier = new RestRailwayCarrier();
        restRailwayCarrier.setUid(railwayCarrier.getCode());
        restRailwayCarrier.setName(RestConverter.convertTranslations2Rest(railwayCarrier.getTranslations()));
        restRailwayCarrier.setCode(RestConverter.convertCodes2Rest(railwayCarrier.getCodeVariants()));
        return restRailwayCarrier;
    }

    public static RestHotel convertHotel2Rest(Hotel hotel) {
        if (hotel == null) {
            return null;
        }
        RestHotel restHotel = new RestHotel();
        restHotel.setUid(String.valueOf(hotel.getSabreHotelPropertyNumber()));
        restHotel.setName(hotel.getName());
        restHotel.setAddress(L10nStringHelper.getValue((L10nString)hotel.getAddress(), (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
        restHotel.setCity(RestConverter.convertDictReference2Rest(hotel.getCity()));
        restHotel.setCountry(RestConverter.convertDictReference2Rest(hotel.getCountry()));
        restHotel.setPhone(hotel.getPhone());
        restHotel.setHotelChainCode((String)Optional.ofNullable(hotel.getBrand()).map(DictionaryReference::getCode).orElse(null));
        return restHotel;
    }

    public static RestHotel extractHotel2Rest(HotelProduct hotelProduct) {
        if (hotelProduct == null) {
            return null;
        }
        RestHotel restHotel = new RestHotel();
        restHotel.setUid(hotelProduct.getOriginalHotelPropertyId());
        restHotel.setAggregatorUid(hotelProduct.getHotelPropertyId());
        if (TextUtil.isBlank((String)restHotel.getUid())) {
            restHotel.setUid(restHotel.getAggregatorUid());
        }
        restHotel.setName(hotelProduct.getHotelName());
        restHotel.setAddress(hotelProduct.getHotelAddress());
        restHotel.setCity(RestConverter.convertDictReference2Rest(hotelProduct.getHotelLocation()));
        restHotel.setCountry(RestConverter.convertDictReference2Rest(hotelProduct.getHotelCountry()));
        restHotel.setPhone(hotelProduct.getHotelPhone());
        restHotel.setHotelChainCode(hotelProduct.getHotelChainCode());
        return restHotel;
    }

    public static RestCurrency convertCurrency2Rest(CurrencyInfo currencyInfo) {
        if (currencyInfo == null) {
            return null;
        }
        RestCurrency restCurrency = new RestCurrency();
        restCurrency.setUid(currencyInfo.getCode());
        restCurrency.setName(RestConverter.convertTranslations2Rest(currencyInfo.getTranslations()));
        return restCurrency;
    }

    public static RestAircraft convertAircraft2Rest(Aircraft aircraft) {
        if (aircraft == null) {
            return null;
        }
        RestAircraft restAircraft = new RestAircraft();
        restAircraft.setUid(aircraft.getUid());
        restAircraft.setName(RestConverter.convertTranslations2Rest(aircraft.getTranslations()));
        restAircraft.setCode(RestConverter.convertCodes2Rest(aircraft.getCodeVariants()));
        return restAircraft;
    }

    public static RestRoomSize convertRoomType2Rest(RoomSizeDict roomSizeDict) {
        if (roomSizeDict == null) {
            return null;
        }
        RestRoomSize result = new RestRoomSize();
        result.setUid(roomSizeDict.getUid());
        result.setCode(roomSizeDict.getCode());
        result.setName((String)MiscUtil.findByLocale((Map)roomSizeDict.getTranslations(), (Locale)LocaleHelper.EN_LOCALE));
        return result;
    }

    public static RestBooking convertBooking2Rest(EntityContainer<BookingFile> container) {
        if (container == null || container.getEntity() == null) {
            return null;
        }
        BookingFile bookingFile = (BookingFile)container.getEntity();
        RestBooking restBooking = new RestBooking();
        restBooking.setUid(container.getUid());
        restBooking.setNumber(bookingFile.getNumber());
        restBooking.setCwtBooking(CwtSchemeHelper.isCwtBooking(bookingFile));
        List products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(RestHelper::isApplicableProduct).collect(Collectors.toList());
        bookingFile.getTravellers().stream().map(trv -> RestConverter.convertTraveller2Rest(trv, products)).filter(Objects::nonNull).forEach(restBooking.getTravellers()::add);
        GetSegmentsData getSegmentsData = new GetSegmentsData(bookingFile);
        getSegmentsData.getAirProducts().stream().map(p -> RestConverter.convertProduct2AirTicket(p, getSegmentsData.getReservationAirSegments().get(p.getReservation()))).forEach(restBooking.getAirTickets()::add);
        getSegmentsData.getReservationAirSegments().forEach((reservation, segmentsMap) -> segmentsMap.keySet().stream().map(s -> RestConverter.convertAirSegment2Rest(reservation, s, getSegmentsData.getTravellerAirSegmentsData())).forEach(restBooking.getAirSegments()::add));
        getSegmentsData.getRailProducts().stream().map(p -> RestConverter.convertProduct2RailTicket(p, getSegmentsData.getReservationRailSegments().get(p.getReservation().getUid()))).forEach(restBooking.getRailTickets()::add);
        getSegmentsData.getReservationRailSegments().values().stream().flatMap(map -> map.keySet().stream()).map(s -> RestConverter.convertRailSegment2Rest(s, getSegmentsData.getTravellerRailSegmentsData())).forEach(restBooking.getRailSegments()::add);
        bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(RestHelper::isHotelProduct).map(bp -> (HotelProduct)bp).filter(RestHelper::isApplicableHotelProduct).peek(p -> restBooking.getHotelTickets().add(RestConverter.convertProduct2HotelTicket(p))).forEach(p -> p.getRooms().stream().filter(RestHelper::isApplicableHotelRoom).map(r -> RestConverter.convertHotelSegment2Rest(r, p)).forEach(restBooking.getHotelSegments()::add));
        if (restBooking.getTravellers().size() != bookingFile.getTravellers().size() || !restBooking.getAirTickets().isEmpty() && restBooking.getAirSegments().isEmpty() || restBooking.getAirTickets().isEmpty() && !restBooking.getAirSegments().isEmpty() || !restBooking.getRailTickets().isEmpty() && restBooking.getRailSegments().isEmpty() || restBooking.getRailTickets().isEmpty() && !restBooking.getRailSegments().isEmpty() || restBooking.getHotelTickets().isEmpty() && !restBooking.getHotelSegments().isEmpty()) {
            return null;
        }
        return restBooking;
    }

    private static String translitByDefault(String text) {
        return TranslitUtil.cyr2lat((String)text, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006);
    }

    public static RestTraveller convertTraveller2Rest(Traveller traveller, List<BaseProduct> products) {
        RestTraveller result = new RestTraveller();
        result.setUid(traveller.getUid());
        result.setName(RestConverter.translitByDefault(traveller.getName()));
        Passport passport = traveller.getPassport();
        if (passport != null && !TextUtil.isBlank((String)passport.getLastName()) && !TextUtil.isBlank((String)passport.getFirstName())) {
            result.setFirstName(RestConverter.translitByDefault(passport.getFirstName()));
            result.setLastName(RestConverter.translitByDefault(passport.getLastName()));
            result.setMiddleName(RestConverter.translitByDefault(passport.getMiddleName()));
        }
        DictionaryReference passengerTypeRef = null;
        SabrePassiveSegmentsUtil.SabreAviaParametersProvider paramProvider = null;
        for (BaseProduct baseProduct : products) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler.getTravellers(baseProduct).contains(traveller)) {
                if (passengerTypeRef == null) {
                    passengerTypeRef = handler.getPassengerType(baseProduct, traveller);
                }
                if (RestHelper.isHotelProduct(baseProduct)) {
                    paramProvider = SabrePassiveSegmentsUtil.getHotelProvider((HotelProduct)((HotelProduct)baseProduct), (Traveller)traveller);
                } else if (AirProductHelper.isAirProduct((BaseProduct)baseProduct)) {
                    paramProvider = SabrePassiveSegmentsUtil.getAviaProvider((Product)((Product)baseProduct));
                }
            }
            if (passengerTypeRef == null || paramProvider == null) continue;
            break;
        }
        String title = null;
        if (traveller.getTitle() != null) {
            title = traveller.getTitle().name();
        } else if (passport != null && passengerTypeRef != null && paramProvider != null) {
            title = RestConverter.getTitle(passport, passengerTypeRef, paramProvider);
        }
        result.setTitle(title);
        result.setGender(RestConverter.enum2enum(traveller.getGender(), Gender.class));
        result.setPassengerType((String)Optional.ofNullable(passengerTypeRef).map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).map(BaseDictionary::getCodeVariants).map(m -> (String)m.get(CodeSystem.IATA.name())).orElse(null));
        return result;
    }

    private static String getTitle(Passport passport, DictionaryReference<PassengerType> passengerType, SabrePassiveSegmentsUtil.SabreAviaParametersProvider provider) {
        String title = null;
        if (!provider.isSubsidizedTariff() || !provider.isSuCarrier()) {
            if (!DictHelper.isInfantPassengerType(passengerType) || !provider.isNoInfGenderSuffix()) {
                title = SabrePassiveSegmentsUtil.getNameSuffix(passengerType, (com.gridnine.xtrip.common.model.dict.Gender)passport.getGender());
            }
            if (provider.isTchBlankOwner()) {
                if (DictHelper.isChildPassengerType(passengerType)) {
                    title = String.format("%s*%02d", SabrePassiveSegmentsUtil.getNameSuffix(passengerType, (com.gridnine.xtrip.common.model.dict.Gender)passport.getGender()), provider.getAgeInYears());
                } else if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
                    title = String.format("%s*%02dMTHS", SabrePassiveSegmentsUtil.getNameSuffix(passengerType, (com.gridnine.xtrip.common.model.dict.Gender)passport.getGender()), provider.getAgeInMonths());
                }
            }
        }
        return title;
    }

    public static RestAirSegment convertAirSegment2Rest(Reservation reservation, Segment segment, Map<String, Map<String, RestTravellerData>> travellerSegmentsData) {
        RestAirSegment airSegment = new RestAirSegment();
        airSegment.setSegmentUid(segment.getUid());
        airSegment.setCoupon(segment.getRecordNumber());
        airSegment.setDeparture(RestConverter.convertDictReference2Rest(segment.getDepartureLocation()));
        airSegment.setArrival(RestConverter.convertDictReference2Rest(segment.getArriveLocation()));
        airSegment.setAirline(RestConverter.convertDictReference2Rest(segment.getAirline()));
        airSegment.setAircraft(RestConverter.convertDictReference2Rest(segment.getBoard()));
        airSegment.setFlightNumber(segment.getFlightNo());
        airSegment.setBookingClass(segment.getClassOfSvcCode());
        airSegment.setRecordLocator(segment.getAirlineLocator());
        airSegment.setCrsRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        String departureTime = DATA_STANDARD_FORMAT.get().format(segment.getStartDate());
        airSegment.setDepartureDateTime(departureTime);
        if (segment.getEndDate() != null) {
            String arrivalTime = DATA_STANDARD_FORMAT.get().format(segment.getEndDate());
            airSegment.setArrivalDateTime(arrivalTime);
        }
        airSegment.getTravelerData().putAll(travellerSegmentsData.get(segment.getUid()));
        airSegment.setDepartureTerminal(segment.getDepartTerminal());
        airSegment.setArrivalTerminal(segment.getArriveTerminal());
        return airSegment;
    }

    public static RestRailSegment convertRailSegment2Rest(RailwaySegment railwaySegment, Map<String, Map<String, RestRailTravellerData>> travellerRailSegmentsData) {
        RestRailSegment railSegment = new RestRailSegment();
        railSegment.setRailwayCarrier(RestConverter.convertDictReference2Rest(railwaySegment.getCarrier()));
        railSegment.setSegmentUid(railwaySegment.getUid());
        railSegment.setDepartureStation(RestConverter.convertDictReference2Rest(railwaySegment.getDepartureStation()));
        railSegment.setArrivalStation(RestConverter.convertDictReference2Rest(railwaySegment.getArriveStation()));
        railSegment.setDepartureDateTime((String)Optional.ofNullable(railwaySegment.getDepartureDate()).map(DATA_STANDARD_FORMAT.get()::format).orElse(null));
        railSegment.setArrivalDateTime((String)Optional.ofNullable(railwaySegment.getArriveDate()).map(DATA_STANDARD_FORMAT.get()::format).orElse(null));
        railSegment.setTrainNumber(railwaySegment.getTrainNumber());
        railSegment.setStrand(railwaySegment.getSlot());
        railSegment.setRegistrationAvailable(railwaySegment.isERegEnabled());
        railSegment.setRegistrationPassed(railwaySegment.isHasEReg());
        railSegment.setCarType((RestCarType)Optional.ofNullable(railwaySegment.getCarriageType()).map(e -> TranslitUtil.cyr2lat((String)e.name(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006)).map(RestCarType::valueOf).orElse(null));
        railSegment.setServiceClass((String)Optional.ofNullable(railwaySegment.getServiceClass()).map(cl -> cl.toString(LocaleHelper.RU_LOCALE)).orElse(null));
        railSegment.setCompartment(RestConverter.enum2enum(railwaySegment.getCompartmentType(), RestCompartment.class));
        railSegment.getTravelerData().putAll(travellerRailSegmentsData.get(railwaySegment.getUid()));
        return railSegment;
    }

    private static RestHotelSegment convertHotelSegment2Rest(Room room, HotelProduct hotelProduct) {
        RestHotelSegment hotelSegment = new RestHotelSegment();
        hotelSegment.setSegmentUid(room.getUid());
        hotelSegment.setHotel(RestConverter.extractHotel2Rest(hotelProduct));
        hotelSegment.setSegmentUid(room.getUid());
        hotelSegment.setRoom(RestConverter.convertRoom2Rest(room));
        return hotelSegment;
    }

    private static RestHotelRoom convertRoom2Rest(Room room) {
        RestHotelRoom hotelRoom = new RestHotelRoom();
        String equivCurrency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        hotelRoom.setRate(RestConverter.convertPrice2Rest(room.getEquivalentRate(), equivCurrency));
        hotelRoom.setTotal(RestConverter.convertPrice2Rest(room.getEquivalentPrice(), equivCurrency));
        hotelRoom.setVat(RestConverter.convertPrice2Rest(room.getEquivalentVatPrice(), equivCurrency));
        hotelRoom.setInDate(RestConverter.convertRoomDateTime2Rest(room.getCheckInDate(), room.getCheckInTime()));
        hotelRoom.setOutDate(RestConverter.convertRoomDateTime2Rest(room.getCheckOutDate(), room.getCheckOutTime()));
        hotelRoom.getNightDetails().addAll(RestConverter.convertDailyRates(room.getDailyRates()));
        RoomSizeDict roomSizeDict = (RoomSizeDict)DictionaryCache.get().findByCode(RoomSizeDict.class, room.getRoomSize());
        if (roomSizeDict != null) {
            hotelRoom.setType(RestConverter.convertDictReference2Rest(roomSizeDict.toReference()));
        }
        return hotelRoom;
    }

    private static List<RestNightDetails> convertDailyRates(List<DailyRate> dailyRates) {
        ArrayList<RestNightDetails> result = new ArrayList<RestNightDetails>();
        for (DailyRate dailyRate : dailyRates) {
            Money rate = dailyRate.getRate();
            RestNightDetails details = new RestNightDetails();
            details.setPrice(RestConverter.convertPrice2Rest(rate.getValue(), Optional.ofNullable(rate.getCurrency()).orElse(null)));
            Optional.ofNullable(dailyRate.getStartDate()).map(DATA_STANDARD_FORMAT.get()::format).ifPresent(arg_0 -> ((RestNightDetails)details).setFromDate(arg_0));
            Optional.ofNullable(dailyRate.getEndDate()).map(DATA_STANDARD_FORMAT.get()::format).ifPresent(arg_0 -> ((RestNightDetails)details).setToDate(arg_0));
            result.add(details);
        }
        return result;
    }

    private static String convertRoomDateTime2Rest(Date date, Integer minutes) {
        if (date != null) {
            Date tmp = (Date)date.clone();
            if (minutes != null) {
                tmp.setTime(Duration.ofMinutes(minutes.intValue()).toMillis() + tmp.getTime());
            }
            return DATA_STANDARD_FORMAT.get().format(tmp);
        }
        return null;
    }

    public static RestAirTicket convertProduct2AirTicket(Product product, Map<Segment, String> uniqueSegmentsUids) {
        RestAirTicket ticket = new RestAirTicket();
        ticket.setTicketUid(product.getUid());
        ticket.setTravelerUid(product.getTraveller().getUid());
        ticket.setTravelerType((String)Optional.ofNullable(product.getPassengerType()).map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).map(BaseDictionary::getCodeVariants).map(m -> (String)m.get(CodeSystem.IATA.name())).orElse(null));
        ticket.setSource(RestConverter.convertGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation())));
        ticket.setNumber(RestConverter.getFullTicketNumber(product));
        ticket.setImportDetails(RestConverter.converPassiveSegmentsResult2Rest((BaseProduct)product));
        Money fare = AirProductHelper.getBaseFare((Product)product);
        if (fare != null) {
            ticket.setFare(RestConverter.convertPrice2Rest(fare.getValue(), fare.getCurrency()));
        }
        String equivCurrency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        ticket.setEquivalentFare(RestConverter.convertPrice2Rest(AirProductHelper.getEquivalentFare((Product)product), equivCurrency));
        ticket.setCarrier(RestConverter.convertDictReference2Rest(product.getCarrier()));
        AirProductHelper.getProductSegmentsStream((Product)product).map(uniqueSegmentsUids::get).filter(Objects::nonNull).forEach(ticket.getSegmentsUids()::add);
        product.getTaxes().stream().map(RestConverter::convertTax2Rest).forEach(ticket.getTaxes()::add);
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            ticket.setExchangedDocument(RestConverter.convertProduct2AirExchangedTicket(product.getPreviousProduct(), equivCurrency));
        }
        return ticket;
    }

    private static String convertGdsName(GdsName gdsName) {
        String result;
        String string = result = gdsName != null ? gdsName.toString(Locale.ENGLISH) : null;
        if (gdsName == GdsName.WEB_SITE) {
            result = "WEB";
        }
        return result;
    }

    private static RestAirExchangedTicket convertProduct2AirExchangedTicket(Product product, String equivCurrency) {
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            return null;
        }
        RestAirExchangedTicket result = new RestAirExchangedTicket();
        String ticketNumber = Stream.of(product.getCarrierNumber(), product.getSystemNumber()).filter(Objects::nonNull).collect(Collectors.joining());
        result.setNumber(ticketNumber);
        result.setEquivalentFare(RestConverter.convertPrice2Rest(AirProductHelper.getEquivalentFare((Product)product), equivCurrency));
        product.getTaxes().stream().map(RestConverter::convertTax2Rest).collect(Collectors.toCollection(() -> ((RestAirExchangedTicket)result).getTaxes()));
        return result;
    }

    private static String getFullTicketNumber(Product product) {
        StringBuilder builder = new StringBuilder();
        if (!TextUtil.isBlank((String)product.getCarrierNumber())) {
            builder.append(product.getCarrierNumber());
        }
        builder.append(product.getSystemNumber());
        if (product.getConjCount() > 0 && product.getSystemNumber().matches("[0-9]+")) {
            String endNumber = FormattedNumberUtil.add((String)product.getSystemNumber(), (long)product.getConjCount());
            String ticketDifference = RestConverter.getTicketNumDiff(product.getSystemNumber(), endNumber);
            builder.append("-").append(ticketDifference);
        }
        return builder.toString();
    }

    private static String getTicketNumDiff(String firstTicketNum, String lastTicketNum) {
        int index = 0;
        for (int i = 0; i < firstTicketNum.length(); ++i) {
            if (firstTicketNum.charAt(i) == lastTicketNum.charAt(i)) continue;
            index = i;
            break;
        }
        if (lastTicketNum.length() - index == 1) {
            --index;
        }
        return lastTicketNum.substring(index);
    }

    public static RestRailTicket convertProduct2RailTicket(RailwayProduct product, Map<RailwaySegment, String> railSegments) {
        RestRailTicket railTicket = new RestRailTicket();
        String equivCurrency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        railTicket.setTicketUid(product.getUid());
        product.getSegments().stream().map(railSegments::get).filter(Objects::nonNull).forEach(railTicket.getSegmentUids()::add);
        product.getPassengers().stream().map(BaseIdentity::getUid).forEach(railTicket.getTravelerUids()::add);
        railTicket.setEticket(product.isEticket());
        railTicket.setNumber(product.getSystemNumber());
        railTicket.setImportDetails(RestConverter.converPassiveSegmentsResult2Rest((BaseProduct)product));
        railTicket.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        railTicket.setSource(RestConverter.convertGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation())));
        railTicket.setTotal(RestConverter.convertPrice2Rest(product.getTotalEquivalentFare(), equivCurrency));
        railTicket.setTotalVat(RestConverter.convertPrice2Rest(product.getTotalEquivalentVAT(), equivCurrency));
        return railTicket;
    }

    public static RestHotelTicket convertProduct2HotelTicket(HotelProduct product) {
        RestHotelTicket hotelTicket = new RestHotelTicket();
        hotelTicket.setTicketUid(product.getUid());
        if (product.getGuaranteeType() != null) {
            hotelTicket.setGuarantee(product.getGuaranteeType().toString(LocaleHelper.EN_LOCALE));
        }
        HotelProductHelper.getAvailableCancellationCharges((HotelProduct)product).stream().map(RestConverter::convertCancellationCharge).collect(Collectors.toCollection(() -> ((RestHotelTicket)hotelTicket).getCancellationData()));
        hotelTicket.setNumber(product.getSystemNumber());
        hotelTicket.setSource(RestConverter.convertGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation())));
        hotelTicket.setImportDetails(RestConverter.converPassiveSegmentsResult2Rest((BaseProduct)product));
        product.getTravellers().stream().map(BaseIdentity::getUid).forEach(hotelTicket.getTravelerUids()::add);
        product.getRooms().stream().map(BaseIdentity::getUid).forEach(hotelTicket.getSegmentUids()::add);
        return hotelTicket;
    }

    private static RestCancellationData convertCancellationCharge(CancellationCharge source) {
        if (source == null) {
            return null;
        }
        RestCancellationData result = new RestCancellationData();
        result.setInfo(source.getPolicyText());
        Optional.ofNullable(source.getStartDate()).map(DATA_STANDARD_FORMAT.get()::format).ifPresent(arg_0 -> ((RestCancellationData)result).setStartDate(arg_0));
        Optional.ofNullable(source.getEndDate()).map(DATA_STANDARD_FORMAT.get()::format).ifPresent(arg_0 -> ((RestCancellationData)result).setEndDate(arg_0));
        Optional.ofNullable(source.getPenalty()).map(RateMoney::getMoney).map(RestConverter::convertMoney2Rest).ifPresent(arg_0 -> ((RestCancellationData)result).setPenalty(arg_0));
        return result;
    }

    private static ImportDataDetails converPassiveSegmentsResult2Rest(BaseProduct product) {
        if (RestConverter.isPassiveSegmentsResultEmpty(product)) {
            return null;
        }
        SabrePassiveSegmentsResult result = product.getPassiveSegmentsCreationResult();
        ImportDataDetails importDetails = new ImportDataDetails();
        importDetails.setPcc(result.getPcc());
        importDetails.setPnr(result.getPnr());
        importDetails.setDate(result.getResponseDate() == null ? null : DATA_STANDARD_FORMAT.get().format(result.getResponseDate()));
        return importDetails;
    }

    public static boolean isPassiveSegmentsResultEmpty(BaseProduct product) {
        SabrePassiveSegmentsResult result = product.getPassiveSegmentsCreationResult();
        return result == null || TextUtil.isBlank((String)result.getPnr()) && TextUtil.isBlank((String)result.getPcc());
    }

    public static RestPrice convertPrice2Rest(BigDecimal amount, String currency) {
        RestPrice price = new RestPrice();
        price.setAmount(amount);
        if (TextUtil.nonBlank((String)currency)) {
            price.setCurrency(RestConverter.convertDictReference2Rest(new CurrencyInfoReference(currency)));
        }
        return price;
    }

    public static RestPrice convertMoney2Rest(Money money) {
        if (money == null) {
            return null;
        }
        String currency = Optional.ofNullable(money.getCurrency()).orElse(null);
        return RestConverter.convertPrice2Rest(money.getValue(), currency);
    }

    public static RestTax convertTax2Rest(Tax tax) {
        RestTax restTax = new RestTax();
        restTax.setCode(tax.getCode());
        restTax.setAmount(tax.getEquivalentAmount());
        return restTax;
    }
}

