/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.util.TextUtils;

public class RestHelper {
    private static final String HOTEL_AGGREGATOR_GDS_NAME = "HOTEL_AGGREGATOR";

    public static boolean isRailwayProduct(BaseProduct product) {
        return product instanceof RailwayProduct;
    }

    public static boolean isHotelProduct(BaseProduct product) {
        return product instanceof HotelProduct;
    }

    private static boolean isApplicableBooking(BookingFile bookingFile) {
        return !bookingFile.getTravellers().isEmpty();
    }

    public static boolean isApplicableProduct(BaseProduct product) {
        if (AirProductHelper.isAirProduct((BaseProduct)product)) {
            return RestHelper.isApplicableAirProduct((Product)product);
        }
        if (RestHelper.isRailwayProduct(product)) {
            return RestHelper.isApplicableRailProduct((RailwayProduct)product);
        }
        return RestHelper.isHotelProduct(product) && RestHelper.isApplicableHotelProduct((HotelProduct)product);
    }

    public static boolean isApplicableHotelProduct(HotelProduct product) {
        ProductStatus status = product.getStatus();
        return (ProductStatus.SELL == status || ProductStatus.BOOKING == status && RestHelper.isHotelAggregatorGds(product)) && !product.getTravellers().isEmpty() && product.getNextProduct() == null && !TextUtil.isBlank((String)product.getHotelName()) && product.getHotelLocation() != null && product.getRooms().size() == 1 && product.getRooms().stream().allMatch(RestHelper::isApplicableHotelRoom);
    }

    private static boolean isHotelAggregatorGds(HotelProduct product) {
        return CommonReservationGdsNameInfoHelper.containsGds((Reservation)product.getReservation(), (GdsName)GdsName.HOTEL_AGGREGATOR);
    }

    public static boolean isApplicableRailProduct(RailwayProduct product) {
        return ProductStatus.SELL == product.getStatus() && product.getPassengers().size() == 1 && product.getNextProduct() == null && product.getSegments().size() == 1 && product.getSegments().stream().allMatch(RestHelper::isApplicableRailSegment);
    }

    public static boolean isApplicableAirProduct(Product product) {
        return ProductStatus.SELL == product.getStatus() && !TextUtil.isBlank((String)product.getSystemNumber()) && product.getTraveller() != null && product.getNextProduct() == null && !AirProductHelper.getProductSegmentsList((Product)product).isEmpty() && AirProductHelper.getProductSegmentsStream((Product)product).allMatch(RestHelper::isApplicableAirSegment);
    }

    public static boolean isApplicableAirSegment(Segment segment) {
        return segment.getDepartureLocation() != null && segment.getArriveLocation() != null && segment.getStartDate() != null && segment.getStartDate().after(new Date()) && segment.getAirline() != null && !TextUtil.isBlank((String)segment.getFlightNo()) && !TextUtil.isBlank((String)segment.getClassOfSvcCode());
    }

    public static boolean isApplicableRailSegment(RailwaySegment segment) {
        return segment.getDepartureDate() != null && segment.getDepartureDate().after(new Date()) && segment.getDepartureStation() != null && segment.getArriveStation() != null;
    }

    public static boolean isApplicableHotelRoom(Room room) {
        return room.getCheckInDate() != null && room.getCheckInDate().after(new Date()) && room.getCheckOutDate() != null;
    }

    public static boolean isApplicableReservation(Reservation reservation) {
        return GdsName.SABRE != CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation);
    }

    public static List<EntityContainer<BookingFile>> byPassiveSegmentsAppRestrictions(String pattern) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getOrders().put(BookingFileIndex.Property.createDate.name(), SortOrder.DESC);
        query.setLimit(300);
        if (!TextUtils.isBlank((CharSequence)pattern)) {
            query.getCriteria().setFreeTextPattern(pattern);
        }
        return EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(EntityIndex::getSource).filter(Objects::nonNull).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(bfc -> RestHelper.isApplicableBooking((BookingFile)bfc.getEntity())).filter(bfc -> ((BookingFile)bfc.getEntity()).getReservations().stream().filter(RestHelper::isApplicableReservation).map(Reservation::getProducts).flatMap(Collection::stream).anyMatch(RestHelper::isApplicableProduct)).collect(Collectors.toList());
    }
}

