/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.booking.statistics.RedAppCounterItem;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppLicenceChecker;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.RedAppRestHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.BaseParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.Target;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SabreBinarySecurityTokenAuthInterceptor
implements AuthRestInterceptor {
    private static final String AUTH_HEADER_PREFIX = "SabreBinarySecurityToken ";
    private static final long CACHE_EXPIRY_DAYS = 1L;
    private static final String TEMPORAL_OBJECT_TAG_PREFIX = "sabre_binary_token_";
    private static final long SSO_SALT_LIFETIME_MS = 86400000L;

    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        UserAccount userAccount;
        String authHeader = context.getRequest().getHeader("Authorization");
        if (TextUtil.isBlank((String)authHeader)) {
            this.authorizeOld(context, data);
            return;
        }
        if (!authHeader.startsWith(AUTH_HEADER_PREFIX)) {
            context.setStatus(401);
            throw Xeption.forEndUser((String)L10n.get((String)"INVALID_AUTH_HEADER_FORMAT"), (Object[])new Object[0]);
        }
        String[] authData = authHeader.substring(AUTH_HEADER_PREFIX.length()).split("\\|");
        String target = authData[0];
        String binarySecurityToken = authData[1];
        char[] ssoSalt = UUID.randomUUID().toString().toCharArray();
        try {
            userAccount = SabreBinarySecurityTokenAuthInterceptor.resolveUserAccount(binarySecurityToken, ssoSalt, target, data);
        }
        catch (Throwable t) {
            context.setStatus(401);
            throw t;
        }
        if (userAccount == null) {
            throw Xeption.forEndUser((String)"Unable to authorize user", (Object[])new Object[0]);
        }
        try {
            LogicalStorage.get().authorizeBySsoSalt(userAccount.getLoginName(), ssoSalt, 86400000L);
            data.put(IBusRestRedAppContextKeys.BINARY_SECURITY_TOKEN.name(), binarySecurityToken);
            data.put(IBusRestRedAppContextKeys.REDAPP_TARGET.name(), target);
            data.put(IBusRestRedAppContextKeys.REST_REDAPP_LOGIN.name(), userAccount.getLoginName());
        }
        catch (Exception e) {
            context.setStatus(401);
            throw Xeption.forDeveloper((String)"Authorization failed for user {0}: {1}", (Object[])new Object[]{userAccount.getLoginName(), e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserAccount resolveUserAccount(String binarySecurityToken, char[] ssoSalt, String target, Map<String, Object> ctx) throws Exception {
        UserAccount account;
        EntityContainer<Person> personCtr;
        String agentSign = null;
        String pcc = null;
        TemporalObject cached = SabreBinarySecurityTokenAuthInterceptor.findCachedToken(binarySecurityToken);
        if (cached != null) {
            cached.setExpired(SabreBinarySecurityTokenAuthInterceptor.calculateExpiryTime());
            AssetsStorage.get().save((BaseAsset)cached);
            String[] data = new String(cached.getData()).split("\\|");
            agentSign = data[1];
            pcc = data[2];
        } else {
            ArrayList<RedAppCounterItem> redAppCounterItems = new ArrayList<RedAppCounterItem>();
            try {
                String response = SabreBinarySecurityTokenAuthInterceptor.executeSabreCommand("*S", binarySecurityToken, target, ctx, redAppCounterItems);
                agentSign = SabreBinarySecurityTokenAuthInterceptor.extractAgentSign(response);
                pcc = SabreBinarySecurityTokenAuthInterceptor.extractPCC(response);
                ctx.put(IBusRestRedAppContextKeys.REST_REDAPP_CURRENT_PCC.name(), SabreBinarySecurityTokenAuthInterceptor.extractCurrentPCC(response));
            }
            finally {
                for (RedAppCounterItem item : redAppCounterItems) {
                    item.setSabrePcc(pcc);
                    item.setSabreAgentSign(agentSign);
                    RedAppRestHelper.asyncSaveData(item);
                }
            }
            SabreBinarySecurityTokenAuthInterceptor.cacheToken(binarySecurityToken, agentSign, pcc);
        }
        ctx.put(IBusRestRedAppContextKeys.REST_REDAPP_PCC.name(), pcc);
        ctx.put(IBusRestRedAppContextKeys.REST_REDAPP_AGENT_SIGN.name(), agentSign);
        try {
            personCtr = SabreBinarySecurityTokenAuthInterceptor.findPersonByAgentSignAndPcc(agentSign, pcc);
        }
        catch (IllegalArgumentException e) {
            throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)"SEVERAL_AGENTS_FOUND_WITH_PCC_AS", (Object[])new Object[]{pcc, agentSign}), (Object[])new Object[0]);
        }
        if (personCtr == null) {
            account = SabreBinarySecurityTokenAuthInterceptor.handlePersonNotFound(agentSign, pcc, binarySecurityToken, target, ssoSalt, ctx);
            if (account == null) {
                throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)"AGENT_NOT_FOUND_WITH_PCC_AS", (Object[])new Object[]{pcc, agentSign}), (Object[])new Object[0]);
            }
            return account;
        }
        account = SabreBinarySecurityTokenAuthInterceptor.findUserAccountForPerson((Person)personCtr.getEntity());
        if (account == null && (account = SabreBinarySecurityTokenAuthInterceptor.handleUserAccountNotFound(agentSign, pcc, binarySecurityToken, target, personCtr, ssoSalt, ctx)) == null) {
            throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)"ACCOUNT_NOT_FOUND_WITH_PCC_AS", (Object[])new Object[]{pcc, agentSign}), (Object[])new Object[0]);
        }
        account.setSsoSalt(ssoSalt);
        account.setSsoSaltDigestLastUpdateDate(new Date());
        AssetsStorage.get().save((BaseAsset)account);
        return account;
    }

    private static TemporalObject findCachedToken(String binarySecurityToken) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)TEMPORAL_OBJECT_TAG_PREFIX.concat(MiscUtil.md5((String)binarySecurityToken))));
        query.getPreferredProperties().add("uid");
        return (TemporalObject)Streams.singleOrNull(AssetsStorage.get().search(TemporalObject.class, query).getData().stream().map(BaseAsset::getUid).map(toUid -> (TemporalObject)AssetsStorage.get().load(TemporalObject.class, toUid)).filter(to -> SabreBinarySecurityTokenAuthInterceptor.matchesToken(to, binarySecurityToken)));
    }

    private static boolean matchesToken(TemporalObject to, String binarySecurityToken) {
        return binarySecurityToken.equals(new String(to.getData()).split("\\|")[0]);
    }

    private static Date calculateExpiryTime() {
        return Date.from(LocalDateTime.now().plusDays(1L).atZone(ZoneId.systemDefault()).toInstant());
    }

    private static String executeSabreCommand(String command, String binarySecurityToken, String target, Map<String, Object> addContext, List<RedAppCounterItem> redAppCounterItems) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.putAll(addContext);
        data.put("SABRE_COMMAND_REQUEST", command);
        data.put("BINARY_SECURITY_TOKEN", binarySecurityToken);
        data.put("REDAPP_ENDPOINT_URL", RedAppUtils.getEndpointUrl(Target.valueOf((String)target)));
        data.put(IBusRestRedAppContextKeys.REST_REDAPP_COUNTER_ITEMS_TO_SAVE_LATER.name(), redAppCounterItems);
        IntegrationBusFacade.get().processRouteSync("redapp:service:sabre-command", data);
        return (String)data.get("SABRE_COMMAND_RESPONSE");
    }

    private static String extractAgentSign(String response) {
        return response.substring(11, 13);
    }

    private static String extractPCC(String response) {
        return response.substring(5, 9);
    }

    private static String extractCurrentPCC(String response) {
        return response.substring(0, 4);
    }

    private static EntityContainer<Person> findPersonByAgentSignAndPcc(String agentSign, String pcc) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.gdsName.name(), (Object)GdsName.SABRE));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.reference.name(), (Object)agentSign));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.agencyCode.name(), (Object)pcc));
        query.setLimit(2);
        return (EntityContainer)Streams.singleOrNull(EntityStorage.get().search(GdsReferenceIndex.class, query).getData().stream().map(GdsReferenceIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)));
    }

    private static UserAccount findUserAccountForPerson(Person person) {
        return (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)person.getLoginName());
    }

    private static UserAccount handlePersonNotFound(String agentSign, String pcc, String binarySecurityToken, String target, char[] ssoSault, Map<String, Object> ctx) throws Exception {
        MiscUtil.Pair<Boolean, EntityReference<Organization>> autoCreateAllowedForPcc = SabreBinarySecurityTokenAuthInterceptor.isAutoCreateAllowedForPcc(pcc);
        if (((Boolean)autoCreateAllowedForPcc.getFirst()).booleanValue()) {
            UserAccount userAccount = SabreBinarySecurityTokenAuthInterceptor.createUserAccount(agentSign, pcc, binarySecurityToken, target, ssoSault, ctx);
            Person person = new Person();
            person.setLoginName(userAccount.getLoginName());
            person.getLastName().setStringValue(userAccount.getFullName());
            person.getTypes().add(PersonType.AGENT);
            PersonEmployment pe = new PersonEmployment();
            pe.setOrganization((EntityReference)autoCreateAllowedForPcc.getSecond());
            pe.setMainEmployment(true);
            person.getEmployments().add(pe);
            GdsReference reference = new GdsReference();
            reference.setGdsName(GdsName.SABRE);
            reference.setAgencyCode(pcc);
            reference.setAgency((EntityReference)autoCreateAllowedForPcc.getSecond());
            reference.setReference(agentSign);
            person.getGdsReferences().add(reference);
            EntityContainer personCtr = EntityContainer.create((BaseEntity)person);
            personCtr.getVersionInfo().setDataSource("SabreBinarySecurityTokenAuthInterceptor");
            EntityStorage.get().save(personCtr, true);
            return userAccount;
        }
        return null;
    }

    private static UserAccount handleUserAccountNotFound(String agentSign, String pcc, String binarySecurityToken, String target, EntityContainer<Person> personCtr, char[] ssoSalt, Map<String, Object> ctx) throws Exception {
        if (((Boolean)SabreBinarySecurityTokenAuthInterceptor.isAutoCreateAllowedForPcc(pcc).getFirst()).booleanValue()) {
            UserAccount userAccount = SabreBinarySecurityTokenAuthInterceptor.createUserAccount(agentSign, pcc, binarySecurityToken, target, ssoSalt, ctx);
            ((Person)personCtr.getEntity()).setLoginName(userAccount.getLoginName());
            personCtr.getVersionInfo().setDataSource("SabreBinarySecurityTokenAuthInterceptor");
            EntityStorage.get().save(personCtr, true);
            return userAccount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserAccount createUserAccount(String agentSign, String pcc, String binarySecurityToken, String target, char[] ssoSalt, Map<String, Object> ctx) throws Exception {
        UserAccount userAccount;
        String loginName = null;
        ArrayList<RedAppCounterItem> redAppCounterItems = new ArrayList<RedAppCounterItem>();
        try {
            String userData = SabreBinarySecurityTokenAuthInterceptor.executeSabreCommand("H*ASA".concat(agentSign), binarySecurityToken, target, ctx, redAppCounterItems);
            String agentId = userData.split("\\s+")[3].split("-")[0];
            UserAccount userAccount2 = new UserAccount();
            loginName = String.format("sabre_%s_%s", pcc, agentSign);
            userAccount2.setLoginName(loginName);
            userAccount2.setActive(true);
            userAccount2.setActiveLastUpdateDate(new Date());
            userAccount2.setFullName(agentId);
            userAccount2.setSsoSalt(ssoSalt);
            userAccount2.setSsoSaltDigestLastUpdateDate(new Date());
            userAccount2.setNotes(String.format("Auto-created from Sabre agent sign %s PCC %s", agentSign, pcc));
            userAccount2.setCreateDate(new Date());
            AssetsStorage.get().save((BaseAsset)userAccount2);
            userAccount = userAccount2;
        }
        catch (Throwable throwable) {
            for (RedAppCounterItem item : redAppCounterItems) {
                item.setRestLogin(loginName);
                RedAppRestHelper.asyncSaveData(item);
            }
            throw throwable;
        }
        for (RedAppCounterItem item : redAppCounterItems) {
            item.setRestLogin(loginName);
            RedAppRestHelper.asyncSaveData(item);
        }
        return userAccount;
    }

    private static MiscUtil.Pair<Boolean, EntityReference<Organization>> isAutoCreateAllowedForPcc(String pcc) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.redappLicenseKey.name(), null));
        query.getPreferredProperties().add(OrganizationIndex.Property.redappLicenseKey.name());
        for (OrganizationIndex idx : EntityStorage.get().search(OrganizationIndex.class, query).getData()) {
            if (!RedAppLicenceChecker.getLicensedApps(idx.getRedappLicenseKey()).getAutoCreateUsersAllowedPccs().contains(pcc)) continue;
            return new MiscUtil.Pair((Object)true, (Object)idx.getSource());
        }
        return new MiscUtil.Pair((Object)false, null);
    }

    private static void cacheToken(String binarySecurityToken, String agentSign, String pcc) {
        TemporalObject temporalObject = new TemporalObject();
        temporalObject.setTag(TEMPORAL_OBJECT_TAG_PREFIX.concat(MiscUtil.md5((String)binarySecurityToken)));
        temporalObject.setData(String.join((CharSequence)"|", binarySecurityToken, agentSign, pcc).getBytes());
        temporalObject.setExpired(SabreBinarySecurityTokenAuthInterceptor.calculateExpiryTime());
        AssetsStorage.get().save((BaseAsset)temporalObject);
    }

    public void authorizeOld(RestContext context, Map<String, Object> data) {
        BaseParameters parameters = (BaseParameters)data.get(IBusRestContextKeys.REST_PARAMS.name());
        String login = parameters.getUserLogin();
        if (TextUtil.isBlank((String)login)) {
            context.setStatus(400);
            throw Xeption.forDeveloper((String)"Field userLogin is not specified", (Object[])new Object[0]);
        }
        String password = parameters.getUserPassword();
        if (TextUtil.isBlank((String)password)) {
            context.setStatus(400);
            throw Xeption.forDeveloper((String)"Field userPassword is not specified", (Object[])new Object[0]);
        }
        data.put(IBusRestRedAppContextKeys.REST_REDAPP_LOGIN.name(), login);
        if (parameters.getBinarySecurityToken() != null) {
            data.put(IBusRestRedAppContextKeys.BINARY_SECURITY_TOKEN.name(), parameters.getBinarySecurityToken());
        }
        if (parameters.getTarget() != null) {
            data.put(IBusRestRedAppContextKeys.REDAPP_TARGET.name(), parameters.getTarget().name());
        }
        byte[] digestedPassword = Base64.getDecoder().decode(password);
        try {
            LogicalStorage.get().authorize(login, digestedPassword);
        }
        catch (Exception e) {
            try {
                char[] decodedPassword = new String(digestedPassword).toCharArray();
                LogicalStorage.get().authorize(login, decodedPassword);
            }
            catch (Exception e2) {
                context.setStatus(401);
                throw Xeption.forDeveloper((String)"An error occurred while log in for user {0}, {1}", (Throwable)e2, (Object[])new Object[]{login, e2.getMessage()});
            }
        }
    }
}

