/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.addImportResult;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ImportDataParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ImportDataResult;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class AddImportResultProcessor
extends BaseProcessor {
    private static final ThreadLocal<SimpleDateFormat> DATA_STANDARD_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));

    public void process(MessageContext ctx) throws Exception {
        Date parsedDate;
        ImportDataParameters parameters = (ImportDataParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String pcc = parameters.getImportDataDetails().getPcc();
        String pnr = parameters.getImportDataDetails().getPnr();
        String date = parameters.getImportDataDetails().getDate();
        if (TextUtil.isBlank((String)pcc) || TextUtil.isBlank((String)date)) {
            throw Xeption.forDeveloper((String)"These parameters must be non-empty: pcc {0}, date {1}", (Object[])new Object[]{pcc, parameters.getImportDataDetails().getDate()});
        }
        try {
            parsedDate = DATA_STANDARD_FORMAT.get().parse(parameters.getImportDataDetails().getDate());
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Cannot parse date {0}", (Object[])new Object[]{parameters.getImportDataDetails().getDate()});
        }
        EntityContainer bkCtr = EntityStorage.get().resolve(new EntityReference(parameters.getBookingUid(), BookingFile.class, null));
        if (bkCtr == null || bkCtr.getEntity() == null) {
            throw Xeption.forDeveloper((String)"Cannot find BookingFile with uid {0}", (Object[])new Object[]{parameters.getBookingUid()});
        }
        SabrePassiveSegmentsResult passiveSegmentsResult = new SabrePassiveSegmentsResult();
        passiveSegmentsResult.setResponseDate(parsedDate);
        passiveSegmentsResult.setPnr(pnr);
        passiveSegmentsResult.setPcc(pcc);
        parameters.getProductUids().stream().map(uid -> BookingHelper.findProduct((BookingFile)((BookingFile)bkCtr.getEntity()), (String)uid)).filter(Objects::nonNull).forEach(p -> p.setPassiveSegmentsCreationResult(passiveSegmentsResult));
        EntityStorage.get().save(bkCtr, false);
        ImportDataResult result = new ImportDataResult();
        result.setBookingNumber(((BookingFile)bkCtr.getEntity()).getNumber());
        result.setMessage("Done");
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

