/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.calculateVat;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CalculateVatParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestPrice;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestTax;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.SegmentLocations;
import java.util.List;
import java.util.Objects;

public class VatCalculationParametersValidationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CalculateVatParameters parameters = (CalculateVatParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        this.validateVatCalculationParameters(parameters);
    }

    private void validateVatCalculationParameters(CalculateVatParameters parameters) {
        this.validateValidatingAirlineCode(parameters.getValidatingAirlineCode());
        this.validateFare(parameters.getFare());
        this.validateAirSegmentsLocations(parameters.getSegments());
        this.validateTaxes(parameters.getTaxes());
    }

    private void validateValidatingAirlineCode(String validatingAirlineCode) {
        if (TextUtil.isBlank((String)validatingAirlineCode)) {
            throw Xeption.forDeveloper((String)"[validatingAirlineCode] not set.", (Object[])new Object[0]);
        }
    }

    private void validateFare(RestPrice fare) {
        if (fare == null) {
            throw Xeption.forDeveloper((String)"[fare] not set.", (Object[])new Object[0]);
        }
        if (fare.getAmount() == null) {
            throw Xeption.forDeveloper((String)"[amount] in [fare] not set.", (Object[])new Object[0]);
        }
    }

    private void validateAirSegmentsLocations(List<SegmentLocations> segments) {
        if (segments.isEmpty()) {
            throw Xeption.forDeveloper((String)"[segments] not set.", (Object[])new Object[0]);
        }
        segments.stream().filter(Objects::nonNull).filter(s -> TextUtil.isBlank((String)s.getDeparture()) || TextUtil.isBlank((String)s.getArrival())).findFirst().ifPresent(s -> {
            if (TextUtil.isBlank((String)s.getDeparture())) {
                throw Xeption.forDeveloper((String)"[departure] in [segments] not set.", (Object[])new Object[0]);
            }
            if (TextUtil.isBlank((String)s.getArrival())) {
                throw Xeption.forDeveloper((String)"[arrival] in [segments] not set.", (Object[])new Object[0]);
            }
        });
    }

    private void validateTaxes(List<RestTax> taxes) {
        if (!taxes.isEmpty()) {
            taxes.stream().filter(Objects::nonNull).filter(t -> t.getAmount() == null || TextUtil.isBlank((String)t.getCode())).findFirst().ifPresent(s -> {
                if (s.getAmount() == null) {
                    throw Xeption.forDeveloper((String)"[amount] in [taxes] not set.", (Object[])new Object[0]);
                }
                if (TextUtil.isBlank((String)s.getCode())) {
                    throw Xeption.forDeveloper((String)"[code] in [taxes] not set.", (Object[])new Object[0]);
                }
            });
        }
    }
}

