/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getAfsEnabled;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.GetAfsEnabledParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.GetAfsEnabledResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessage;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;

public class GetAfsEnabledProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetAfsEnabledParameters parameters = (GetAfsEnabledParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        GetAfsEnabledResult result = new GetAfsEnabledResult();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        String dkNumber = parameters.getDkNumber();
        if (TextUtil.isBlank((String)dkNumber)) {
            throw Xeption.forDeveloper((String)"DK number is not specified", (Object[])new Object[0]);
        }
        EntityContainer clientCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)dkNumber);
        if (clientCtr == null) {
            RedappMessage message = new RedappMessage();
            message.setMsgType(RedappMessageType.Error);
            message.setText(String.format("Organization with dk code %s not found", dkNumber));
            result.getMessages().add(message);
            return;
        }
        result.setOrganizationUid(clientCtr.getUid());
        StatisticsHelper.getAfsTypesFromString((String)((Organization)clientCtr.getEntity()).getAfsSettings()).forEach(afsType -> {
            if (AFSType.AFSBKG == afsType) {
                result.setBookingStatistic(true);
            }
            if (AFSType.AFSTKT == afsType) {
                result.setTicketingStatistic(true);
            }
        });
    }
}

