/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getAgentsOrganization;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppLicenceChecker;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestConverter;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.GetAgentsOrganizationResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.GetLicensedAppsResult;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class GetAgentsOrganizationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetAgentsOrganizationResult result = new GetAgentsOrganizationResult();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        String login = (String)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_LOGIN);
        this.decodeAuth(login, ctx);
        EntityContainer personContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_AGENT);
        Person person = (Person)personContainer.getEntity();
        EntityContainer organizationContainer = null;
        List mains = person.getEmployments().stream().filter(PersonEmployment::isMainEmployment).filter(emp -> !(emp.getClosed() != null && !new Date().before(emp.getClosed()) || emp.getOpened() != null && !new Date().after(emp.getOpened()))).map(emp -> EntityStorage.get().resolve(emp.getOrganization())).filter(orgCtr -> orgCtr != null && ((Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY)).collect(Collectors.toList());
        if (mains.size() == 1) {
            organizationContainer = (EntityContainer)mains.get(0);
        } else if (mains.isEmpty()) {
            List notMains = person.getEmployments().stream().filter(emp -> !(emp.getClosed() != null && !new Date().before(emp.getClosed()) || emp.getOpened() != null && !new Date().after(emp.getOpened()))).map(emp -> EntityStorage.get().resolve(emp.getOrganization())).filter(orgCtr -> orgCtr != null && ((Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY)).collect(Collectors.toList());
            if (notMains.size() == 1) {
                organizationContainer = (EntityContainer)notMains.get(0);
            } else if (!notMains.isEmpty()) {
                throw Xeption.forEndUser((String)L10n.get((String)"NO_MAIN_EMPLOYMENT_FOUND"), (Object[])new Object[0]);
            }
        } else {
            throw Xeption.forEndUser((String)L10n.get((String)"SEVERAL_MAIN_EMPLOYMENTS_FOUND"), (Object[])new Object[0]);
        }
        if (organizationContainer == null) {
            throw Xeption.forEndUser((String)L10n.get((String)"NO_EMPLOYMENT_FOUND"), (Object[])new Object[0]);
        }
        String licenseKey = ((Organization)organizationContainer.getEntity()).getRedappSettings().getLicenseKey();
        GetLicensedAppsResult getLicensedAppsResult = RedAppLicenceChecker.getLicensedApps(licenseKey);
        result.setLicensedApps(getLicensedAppsResult);
        result.setEntity(RestConverter.convertAgentsOrganizationToRest((EntityContainer<Organization>)organizationContainer));
        this.log.info(String.format("LICENSE_REQUSEST: RedApp_user: %s, profile: %s, organization: %s, has_license_key: %s, app_list: %s", login, person, organizationContainer.toReference(), TextUtil.nonBlank((String)licenseKey), getLicensedAppsResult.getApps().stream().map(Enum::name).collect(Collectors.joining(","))));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void decodeAuth(String login, MessageContext ctx) throws Exception {
        if (login != null) {
            EntityStorage entityStorage = EntityStorage.get();
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)login));
            SearchResult searchResult = entityStorage.search(PersonIndex.class, searchQuery);
            if (searchResult.getData().size() == 0) {
                String msg = String.format("NO PROFILE FOUND IN MOM WITH LOGIN %s", "");
                this.log.error(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            PersonIndex personIndex = (PersonIndex)searchResult.getData().get(0);
            EntityContainer personContainer = entityStorage.resolve(personIndex.getSource());
            if (personContainer == null) {
                String msg = String.format("PERSON PROFILE NOT RESOLVED FOR LOGIN %s", "");
                this.log.error(msg);
                throw Xeption.forEndUser((String)msg, (Object[])new Object[0]);
            }
            ctx.putObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_AGENT, (Object)personContainer);
        }
    }
}

