/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getDictReferences;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestConverter;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ReferencesParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ReferencesResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestReference;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class GetDictReferencesProcessor
extends BaseProcessor {
    private static final int LIMIT = 300;

    public void process(MessageContext ctx) throws Exception {
        ReferencesParameters parameters = (ReferencesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ReferencesResult result = new ReferencesResult();
        switch (parameters.getType()) {
            case Airline: {
                result.getReferences().addAll(this.getAllDictReferences(Airline.class, parameters.getPattern()));
                break;
            }
            case GeoLocation: {
                result.getReferences().addAll(this.getAllDictReferences(GeoLocation.class, parameters.getPattern()));
                break;
            }
            case Country: {
                result.getReferences().addAll(this.getAllDictReferences(Country.class, parameters.getPattern()));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Illegal dict search type %s", parameters.getType()));
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private <T extends BaseDictionary> List<RestReference> getAllDictReferences(Class<T> clazz, String pattern) {
        if (!TextUtil.isBlank((String)pattern)) {
            LinkedHashSet result = new LinkedHashSet();
            DictionaryCache.get().search(clazz, pattern.toUpperCase()).stream().map(BaseDictionary::toReference).forEach(result::add);
            DictionaryCache.get().search(clazz, pattern.toLowerCase()).stream().map(BaseDictionary::toReference).forEach(result::add);
            return result.stream().limit(300L).map(RestConverter::convertDictReference2Rest).collect(Collectors.toList());
        }
        return DictionaryCache.get().getAll(clazz).values().stream().limit(300L).map(BaseDictionary::toReference).map(RestConverter::convertDictReference2Rest).collect(Collectors.toList());
    }
}

