/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getEntities;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.PropertyHandler;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestConverter;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.AircraftsListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.AirlinesListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.BookingsListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CountriesListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CurrenciesListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.EntitiesParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.GeoLocationsListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.HotelsListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RailwayCarriersListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RailwayStationListResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestBooking;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestEntity;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestHotel;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestRailwayStation;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RoomTypeListResult;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GetEntitiesProcessor
extends BaseProcessor {
    private static final int LIMIT = 300;

    public void process(MessageContext ctx) throws Exception {
        BookingsListResult result;
        EntitiesParameters parameters = (EntitiesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        switch (parameters.getType()) {
            case Airline: {
                AirlinesListResult airlinesListResult = new AirlinesListResult();
                airlinesListResult.getEntities().addAll(this.getAllDictEntities(Airline.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertAirline2Rest));
                result = airlinesListResult;
                break;
            }
            case GeoLocation: {
                GeoLocationsListResult geoLocationsListResult = new GeoLocationsListResult();
                geoLocationsListResult.getEntities().addAll(this.getAllDictEntities(GeoLocation.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertGeoLocation2Rest));
                result = geoLocationsListResult;
                break;
            }
            case Country: {
                CountriesListResult countriesListResult = new CountriesListResult();
                countriesListResult.getEntities().addAll(this.getAllDictEntities(Country.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertCountry2Rest));
                result = countriesListResult;
                break;
            }
            case BookingFile: {
                BookingsListResult bookingsListResult = new BookingsListResult();
                bookingsListResult.getEntities().addAll(this.getBookings(parameters.getPattern()));
                result = bookingsListResult;
                break;
            }
            case Currency: {
                CurrenciesListResult listResult = new CurrenciesListResult();
                listResult.getEntities().addAll(this.getAllDictEntities(CurrencyInfo.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertCurrency2Rest));
                result = listResult;
                break;
            }
            case Aircraft: {
                AircraftsListResult aircraftsListResult = new AircraftsListResult();
                aircraftsListResult.getEntities().addAll(this.getAllDictEntities(Aircraft.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertAircraft2Rest));
                result = aircraftsListResult;
                break;
            }
            case RailwayStation: {
                RailwayStationListResult railwayStationListResult = new RailwayStationListResult();
                railwayStationListResult.getEntities().addAll(this.getRailwayStations(parameters.getPattern(), parameters.getFields(), RestConverter::convertRailwayStation2Rest));
                result = railwayStationListResult;
                break;
            }
            case RailwayCarrier: {
                RailwayCarriersListResult railwayCarriersListResult = new RailwayCarriersListResult();
                railwayCarriersListResult.getEntities().addAll(this.getAllDictEntities(RailwayCarrier.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertRailwayCarrier2Rest));
                result = railwayCarriersListResult;
                break;
            }
            case Hotel: {
                HotelsListResult hotelListResult = new HotelsListResult();
                hotelListResult.getEntities().addAll(this.getAllRemoteDictEntities(parameters.getPattern(), parameters.getFields()));
                result = hotelListResult;
                break;
            }
            case RoomType: {
                RoomTypeListResult roomTypeListResult = new RoomTypeListResult();
                roomTypeListResult.getEntities().addAll(this.getAllDictEntities(RoomSizeDict.class, parameters.getPattern(), parameters.getFields(), RestConverter::convertRoomType2Rest));
                result = roomTypeListResult;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private List<RestRailwayStation> getRailwayStations(String pattern, Map<String, String> propertiesValues, Function<RailwayStation, RestRailwayStation> defaultMapper) {
        Map.Entry firstEntry = propertiesValues.entrySet().stream().findFirst().orElse(null);
        if (firstEntry != null) {
            return this.getRailwayStationsByCard(pattern, firstEntry);
        }
        return this.getAllDictEntities(RailwayStation.class, pattern, propertiesValues, defaultMapper);
    }

    private List<RestRailwayStation> getRailwayStationsByCard(String pattern, Map.Entry<String, String> firstEntry) {
        Set resultAdditional;
        RailwayStationVendorCardType type = (RailwayStationVendorCardType)PropertyHandler.getValue(firstEntry);
        Set result = new LinkedHashSet();
        if (TextUtil.nonBlank((String)pattern)) {
            result = DictionaryCache.get().lookup(RailwayStation.class, pattern.toUpperCase(), new String[0]);
            resultAdditional = DictionaryCache.get().search(RailwayStation.class, pattern.toLowerCase());
        } else {
            resultAdditional = DictionaryCache.get().getAll(RailwayStation.class).values();
        }
        return Stream.of(result, this.applySortAndLimit(resultAdditional)).flatMap(Collection::stream).distinct().filter(d -> d.getVendorCards().stream().map(RailwayStationVendorCard::getType).anyMatch(arg_0 -> type.equals(arg_0))).map(d -> RestConverter.convertRailwayStationByCard2Rest(d, type)).collect(Collectors.toList());
    }

    private <T extends BaseDictionary> Set<T> applySortAndLimit(Collection<T> resultAdditional) {
        Locale locale = LocaleManager.get().getCurrentLocale();
        return resultAdditional.stream().filter(this::filterByCriterions).limit(300L).sorted((a1, a2) -> this.compareSafe(locale, (String)MiscUtil.findByLocale((Map)a1.getTranslations(), (Locale)locale), (String)MiscUtil.findByLocale((Map)a2.getTranslations(), (Locale)locale))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <T extends BaseDictionary> Set<T> getValuesAdditional(Class<T> clazz, String pattern, Map<String, String> propertiesValues) {
        Collection resultAdditional = !TextUtil.isBlank((String)pattern) ? DictionaryCache.get().search(clazz, pattern.toLowerCase()) : DictionaryCache.get().getAll(clazz).values();
        for (Map.Entry<String, String> property : propertiesValues.entrySet()) {
            if (PropertyHandler.isEmpty(property)) continue;
            resultAdditional = resultAdditional.stream().filter(d -> this.propertyMatch(d, property)).collect(Collectors.toSet());
        }
        return this.applySortAndLimit(resultAdditional);
    }

    private <T extends BaseDictionary> Set<T> getValuesExact(Class<T> clazz, String pattern, Map<String, String> propertiesValues) {
        Set result = new LinkedHashSet(DictionaryCache.get().lookup(clazz, pattern.toUpperCase(), new String[0]));
        for (Map.Entry<String, String> property : propertiesValues.entrySet()) {
            if (PropertyHandler.isEmpty(property)) continue;
            result = result.stream().filter(d -> this.propertyMatch(d, property)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return result.stream().filter(this::filterByCriterions).limit(300L).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <T extends BaseDictionary, E extends RestEntity> List<E> getAllDictEntities(Class<T> clazz, String pattern, Map<String, String> propertiesValues, Function<T, E> mapper) {
        LinkedHashSet<T> result = TextUtil.nonBlank((String)pattern) ? this.getValuesExact(clazz, pattern, propertiesValues) : new LinkedHashSet<T>();
        result.addAll(this.getValuesAdditional(clazz, pattern, propertiesValues));
        return result.stream().map(mapper).collect(Collectors.toList());
    }

    private List<RestHotel> getAllRemoteDictEntities(String pattern, Map<String, String> propertiesValues) {
        LinkedHashSet hotels;
        block7: {
            String countryName;
            String cityName;
            block6: {
                hotels = new LinkedHashSet();
                cityName = null;
                String cityPattern = propertiesValues.get("city");
                if (!TextUtil.isBlank((String)cityPattern) && DictHelper.findCityByCode((String)cityPattern, (CodeSystem)CodeSystem.IATA) != null) {
                    cityName = cityPattern;
                }
                countryName = null;
                String countryPattern = propertiesValues.get("countyPattern");
                if (!TextUtil.isBlank((String)countryPattern) && !DictHelper.findCountryByCode((String)countryPattern).isEmpty()) {
                    countryName = countryPattern;
                }
                if (!TextUtil.isBlank((String)pattern)) {
                    hotels.addAll(DictHelper.getSabreHotels((String)pattern, null, null, null, null, (int)50));
                }
                if (hotels.isEmpty() && !TextUtil.isBlank((String)cityName)) break block6;
                if (TextUtil.isBlank((String)countryName)) break block7;
            }
            DictHelper.getSabreHotels(null, null, (String)cityName, (String)countryName, (String)pattern, (int)50).stream().sorted(this.compareHotels(pattern)).forEach(hotels::add);
        }
        return hotels.stream().map(RestConverter::convertHotel2Rest).collect(Collectors.toList());
    }

    private Comparator<Hotel> compareHotels(String pattern) {
        return (h1, h2) -> {
            String s1 = h1.getName().toUpperCase();
            String s2 = h2.getName().toUpperCase();
            if (s1.startsWith(pattern.toUpperCase())) {
                if (s2.startsWith(pattern.toUpperCase())) {
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (s2.startsWith(pattern.toUpperCase())) {
                return 1;
            }
            return s1.compareTo(s2);
        };
    }

    private int compareSafe(Locale locale, String a1Name, String a2Name) {
        Collator collator = Collator.getInstance(locale);
        if (TextUtil.isBlank((String)a1Name) && TextUtil.isBlank((String)a2Name)) {
            return 0;
        }
        if (TextUtil.isBlank((String)a1Name)) {
            return 1;
        }
        if (TextUtil.isBlank((String)a2Name)) {
            return -1;
        }
        return collator.compare(a1Name, a2Name);
    }

    private <T extends BaseDictionary> boolean filterByCriterions(T dictionary) {
        if (dictionary instanceof Airline) {
            Airline airline = (Airline)dictionary;
            Date now = new Date();
            return !(airline.getCloseDate() != null && !now.before(airline.getCloseDate()) || airline.getOpenDate() != null && !now.after(airline.getOpenDate()));
        }
        return true;
    }

    private <T extends BaseDictionary> boolean propertyMatch(T dict, Map.Entry<String, String> property) {
        return PropertyHandler.getValue(property).equals(dict.getValue(property.getKey()));
    }

    private List<RestBooking> getBookings(String pattern) {
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pattern)) {
            query.getCriteria().setFreeTextPattern(pattern);
        }
        return RestHelper.byPassiveSegmentsAppRestrictions(pattern).stream().map(RestConverter::convertBooking2Rest).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

