/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getEntity;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestConverter;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.AircraftResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.AirlineResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.BookingResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CountryResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.CurrencyResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.EntityParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.GeoLocationResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.HoldingResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.HotelResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.OrganizationResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.PersonResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RailwayCarrierResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RailwayStationResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RoomTypeResult;

public class GetEntityProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityParameters parameters = (EntityParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        PersonResult result = null;
        switch (parameters.getType()) {
            case Person: {
                result = new PersonResult();
                EntityContainer entity = EntityStorage.get().resolve(new EntityReference(parameters.getUid(), Person.class, null));
                result.setEntity(RestConverter.convertPerson2Rest((EntityContainer<Person>)entity));
                break;
            }
            case Organization: {
                result = new OrganizationResult();
                EntityContainer entity = EntityStorage.get().resolve(new EntityReference(parameters.getUid(), Organization.class, null));
                ((OrganizationResult)result).setEntity(RestConverter.convertOrganization2Rest((EntityContainer<Organization>)entity));
                break;
            }
            case Holding: {
                result = new HoldingResult();
                EntityContainer entity = EntityStorage.get().resolve(new EntityReference(parameters.getUid(), Holding.class, null));
                ((HoldingResult)result).setEntity(RestConverter.convertHolding2Rest((EntityContainer<Holding>)entity));
                break;
            }
            case Airline: {
                result = new AirlineResult();
                ((AirlineResult)result).setEntity(RestConverter.convertAirline2Rest((Airline)DictionaryCache.get().findByCode(Airline.class, parameters.getUid())));
                break;
            }
            case GeoLocation: {
                result = new GeoLocationResult();
                ((GeoLocationResult)result).setEntity(RestConverter.convertGeoLocation2Rest((GeoLocation)DictionaryCache.get().findByCode(GeoLocation.class, parameters.getUid())));
                break;
            }
            case Country: {
                result = new CountryResult();
                ((CountryResult)result).setEntity(RestConverter.convertCountry2Rest((Country)DictionaryCache.get().findByCode(Country.class, parameters.getUid())));
                break;
            }
            case BookingFile: {
                result = new BookingResult();
                EntityContainer entity = EntityStorage.get().resolve(new EntityReference(parameters.getUid(), BookingFile.class, null));
                ((BookingResult)result).setEntity(RestConverter.convertBooking2Rest((EntityContainer<BookingFile>)entity));
                break;
            }
            case Currency: {
                result = new CurrencyResult();
                ((CurrencyResult)result).setEntity(RestConverter.convertCurrency2Rest((CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, parameters.getUid())));
                break;
            }
            case Aircraft: {
                result = new AircraftResult();
                ((AircraftResult)result).setEntity(RestConverter.convertAircraft2Rest((Aircraft)DictionaryCache.get().findByCode(Aircraft.class, parameters.getUid())));
                break;
            }
            case RailwayStation: {
                result = new RailwayStationResult();
                ((RailwayStationResult)result).setEntity(RestConverter.convertRailwayStation2Rest((RailwayStation)DictionaryCache.get().findByCode(RailwayStation.class, parameters.getUid())));
                break;
            }
            case RailwayCarrier: {
                result = new RailwayCarrierResult();
                ((RailwayCarrierResult)result).setEntity(RestConverter.convertRailwayCarrier2Rest((RailwayCarrier)DictionaryCache.get().findByCode(RailwayCarrier.class, parameters.getUid())));
                break;
            }
            case Hotel: {
                result = new HotelResult();
                ((HotelResult)result).setEntity(RestConverter.convertHotel2Rest(DictHelper.getSabreHotel((String)parameters.getUid())));
                break;
            }
            case RoomType: {
                result = new RoomTypeResult();
                ((RoomTypeResult)result).setEntity(RestConverter.convertRoomType2Rest((RoomSizeDict)DictionaryCache.get().findByCode(RoomSizeDict.class, parameters.getUid())));
                break;
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

