/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getImportSettings;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.gds.sabre.SabrePassiveSegmentsConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ImportSettingsResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.PassiveSegmentSettings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetImportSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabrePassiveSegmentsConnectionSettings settings;
        String login = (String)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_LOGIN);
        ArrayList pccSettingsList = new ArrayList();
        EntityContainer<Person> personCtr = GetImportSettingsProcessor.findProfileByLogin(login);
        if (personCtr != null && personCtr.getEntity() != null) {
            pccSettingsList.addAll(((Person)personCtr.getEntity()).getSabrePassiveSegmentsAllowedPCCs());
        }
        if (pccSettingsList.isEmpty() && (settings = SabrePassiveSegmentsUtil.getSabrePassiveSegmentsSettings()) != null) {
            pccSettingsList.addAll(settings.getAllowedPCCs());
        }
        PassiveSegmentSettings impSettings = new PassiveSegmentSettings();
        pccSettingsList.stream().map(SabreProfilesPccSettings::getPcc).filter(Objects::nonNull).map(String::toUpperCase).collect(Collectors.toCollection(() -> ((PassiveSegmentSettings)impSettings).getAllowedPccList()));
        ImportSettingsResult result = new ImportSettingsResult();
        result.setEntity(impSettings);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private static EntityContainer<Person> findProfileByLogin(String login) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)login));
        SearchResult searchResult = EntityStorage.get().search(PersonIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        if (searchResult.getData().size() == 1) {
            return EntityStorage.get().resolve(((PersonIndex)searchResult.getData().get(0)).getSource());
        }
        return null;
    }
}

