/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.getReferences;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestConverter;
import com.gridnine.xtrip.server.web.rest.redapp.service.RestHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ReferencesParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.ReferencesResult;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.util.TextUtils;

public class GetReferencesProcessor
extends BaseProcessor {
    private static final int LIMIT = 300;

    public void process(MessageContext ctx) throws Exception {
        ReferencesParameters parameters = (ReferencesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ReferencesResult result = new ReferencesResult();
        switch (parameters.getType()) {
            case Corporant: {
                result.getReferences().addAll(this.getCorporants(parameters.getPattern()));
                break;
            }
            case Holding: {
                result.getReferences().addAll(this.getHoldings(parameters.getPattern()));
                break;
            }
            case KeyContact: {
                result.getReferences().addAll(this.getKeyContacts(parameters.getPattern()));
                break;
            }
            case Booking: {
                result.getReferences().addAll(this.getBookings(parameters.getPattern()));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Illegal search type %s", parameters.getType()));
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private List<RestReference> getKeyContacts(String pattern) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.keyContacts.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name())}));
        Set keyContactPersons = EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(OrganizationIndex::getSource).map(oi -> EntityStorage.get().resolve(oi)).map(EntityContainer::getEntity).filter(Objects::nonNull).map(Organization::getKeyContacts).flatMap(Collection::stream).map(ProfileKeyContactPerson::getPerson).collect(Collectors.toSet());
        if (!TextUtils.isBlank((CharSequence)pattern)) {
            SearchQuery personQuery = new SearchQuery();
            personQuery.getCriteria().setFreeTextPattern(pattern);
            personQuery.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER));
            Set filteredPersons = EntityStorage.get().search(PersonIndex.class, personQuery).getData().stream().map(PersonIndex::getSource).collect(Collectors.toSet());
            return filteredPersons.stream().filter(keyContactPersons::contains).limit(300L).map(RestConverter::convertReference2Rest).collect(Collectors.toList());
        }
        return keyContactPersons.stream().limit(300L).map(RestConverter::convertReference2Rest).collect(Collectors.toList());
    }

    private List<RestReference> getHoldings(String pattern) {
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pattern)) {
            query.getCriteria().setFreeTextPattern(pattern);
        }
        List referencesIndexes = EntityStorage.get().search(HoldingIndex.class, query).getData().stream().map(EntityIndex::getSource).collect(Collectors.toList());
        return referencesIndexes.stream().limit(300L).map(RestConverter::convertReference2Rest).collect(Collectors.toList());
    }

    private List<RestReference> getCorporants(String pattern) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name())}));
        if (!TextUtil.isBlank((String)pattern)) {
            query.getCriteria().setFreeTextPattern(pattern);
        }
        List referencesIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(EntityIndex::getSource).collect(Collectors.toList());
        return referencesIndexes.stream().map(RestConverter::convertReference2Rest).collect(Collectors.toList());
    }

    private List<RestReference> getBookings(String pattern) {
        return RestHelper.byPassiveSegmentsAppRestrictions(pattern).stream().map(EntityContainer::toReference).map(RestConverter::convertReference2Rest).collect(Collectors.toList());
    }
}

