/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.logger;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.json.JSONObject;

public class RedAppLoggerDocumentBuilder {
    private static FastDateFormat DF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void BuildLogDocument(Map<String, Object> data, RestContext context, Date startDate, String error) throws Exception {
        byte[] content;
        String url = context.getRequest().getRequestURL().toString();
        JSONObject jsonRequest = context.getRequestJsonObject();
        EntityContainer container = (EntityContainer)data.get(IBusBookingContextKeys.BOOKING_FILE_CONTAINER.name());
        RestServiceProvider.Operation restOperation = (RestServiceProvider.Operation)data.get(IBusRestContextKeys.REST_OPERATION.name());
        Object restParams = data.get(IBusRestContextKeys.REST_PARAMS.name());
        JsonMarshaller jsonMarshaller = (JsonMarshaller)data.get(IBusRestContextKeys.JSON_MARSHALLER.name());
        Date now = new Date();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            JsonFactory jfactory = new JsonFactory();
            JsonGenerator jGenerator = jfactory.createGenerator((OutputStream)baos, JsonEncoding.UTF8);
            OutputStreamWriter writer = new OutputStreamWriter(baos);
            try {
                Validatable validatableParams;
                List validationMessages;
                jGenerator.writeStartObject();
                jGenerator.writeStringField("startDate", DF.format(startDate));
                jGenerator.writeStringField("endDate", DF.format(now));
                jGenerator.writeNumberField("timingMs", now.getTime() - startDate.getTime());
                jGenerator.writeStringField("requestURL", url);
                jGenerator.writeStringField("method", restOperation.getMethod());
                jGenerator.writeStringField("routeId", restOperation.getRouteId());
                if (jsonRequest != null) {
                    jGenerator.writeFieldName("request");
                    jGenerator.flush();
                    writer.write(":");
                    jsonRequest.write((Writer)writer);
                    writer.flush();
                    ((JsonWriteContext)jGenerator.getOutputContext()).writeValue();
                }
                if (data.get("REST_RESULT") != null) {
                    jGenerator.writeFieldName("response");
                    jGenerator.writeStartObject();
                    jGenerator.writeFieldName("result");
                    jGenerator.writeRawValue(jsonMarshaller.marshal(data.get("REST_RESULT")));
                    jGenerator.writeEndObject();
                }
                if (restParams instanceof Validatable && !(validationMessages = ValidationHelper.getAllValidationMessages((Validatable)(validatableParams = (Validatable)restParams)).values().stream().flatMap(Collection::stream).filter(validationMessage -> TextUtil.nonBlank((String)validationMessage.getText())).collect(Collectors.toList())).isEmpty()) {
                    jGenerator.writeArrayFieldStart("validationMessages");
                    for (ValidationMessage validationMessage2 : validationMessages) {
                        jGenerator.writeString(validationMessage2.getText());
                    }
                    jGenerator.writeEndArray();
                }
                if (error != null) {
                    jGenerator.writeStringField("error", error);
                }
                jGenerator.writeEndObject();
            }
            finally {
                jGenerator.close();
            }
            content = baos.toByteArray();
        }
        Document document = new Document();
        String docName = "RedAppApi" + RedAppLoggerDocumentBuilder.getServicesFromURL(url);
        document.setTitle(docName);
        document.setName(docName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(now) + ".json");
        document.setContent(content);
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.JSON);
        document.setCreated(now);
        document.setType(DocumentType.REDAPP_LOG);
        if (container != null) {
            document.setOwner(container.toReference());
        }
        EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
        docCtr.getVersionInfo().setDataSource("redApp");
        EntityStorage.get().save(docCtr, false);
    }

    private static String getServicesFromURL(String requestURL) {
        String[] requestURLSplit = requestURL.split("/");
        String services = "";
        if (requestURLSplit.length >= 5) {
            for (int i = 4; i < requestURLSplit.length; ++i) {
                services = services.concat("-" + requestURLSplit[i]);
            }
        }
        return services;
    }
}

