/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.service.logger;

import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptor;
import com.gridnine.xtrip.server.web.rest.redapp.service.logger.RedAppLoggerDocumentBuilder;
import java.util.Date;
import java.util.Map;

public class RedAppLoggerInterceptor
implements GenericRestInterceptor {
    private static final String START_DATE_KEY = RedAppLoggerInterceptor.class.getName() + ".startDate";
    private static final String LOGGING_ENABLED_KEY = RedAppLoggerInterceptor.class.getName() + ".enabled";
    private static final String ERROR_KEY = RedAppLoggerInterceptor.class.getName() + ".error";

    public void before(RestContext context, Map<String, Object> data) throws Exception {
        boolean enabled = RedAppLoggerInterceptor.isEnabled(context);
        data.put(LOGGING_ENABLED_KEY, enabled);
        if (!enabled) {
            return;
        }
        data.put(START_DATE_KEY, new Date());
    }

    public boolean handleException(RestContext context, Map<String, Object> data, Throwable exception) throws Exception {
        if (!Boolean.TRUE.equals(data.get(LOGGING_ENABLED_KEY))) {
            return false;
        }
        data.put(ERROR_KEY, TextUtil.getExceptionStackTrace((Throwable)exception));
        return false;
    }

    public void after(RestContext context, Map<String, Object> data) throws Exception {
        if (!Boolean.TRUE.equals(data.get(LOGGING_ENABLED_KEY))) {
            return;
        }
        Date startDate = (Date)data.get(START_DATE_KEY);
        String error = (String)data.get(ERROR_KEY);
        RedAppLoggerDocumentBuilder.BuildLogDocument(data, context, startDate, error);
    }

    private static boolean isEnabled(RestContext context) {
        String login = UserData.get().getCurrentUser();
        String compoundKey = CommonHelper.getCompoundKey((String)login);
        EntityContainer ctr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)compoundKey, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS);
        if (ctr == null) {
            return false;
        }
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctr.getEntity();
        return gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRedAppTraces();
    }
}

