/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.redapp.task;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.statistics.SendRedAppCounterDataRequest;
import com.gridnine.xtrip.common.model.booking.statistics.SendRedAppCounterDataResponse;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.web.rest.redapp.assets.SendRedAppCounter;
import com.gridnine.xtrip.server.web.rest.redapp.service.RedAppRestHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendRedAppCounterDataTask
extends BaseScheduledTask {
    private static final Logger log = LoggerFactory.getLogger(SendRedAppCounterDataTask.class);
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);

    protected void doJob() throws Exception {
        if (RUNNING.get()) {
            return;
        }
        try {
            RUNNING.set(true);
            this.process();
        }
        finally {
            RUNNING.set(false);
        }
    }

    private void process() {
        List data = AssetsStorage.get().search(SendRedAppCounter.class, new SearchQuery()).getData();
        if (data.isEmpty()) {
            log.debug("sending redapp counter data: no items");
            return;
        }
        String logPrefix = "sending redapp counter data (" + data.size() + " items): ";
        try {
            SendRedAppCounterDataRequest request = new SendRedAppCounterDataRequest();
            request.setLicenseKey(((ServerConfiguration)Environment.getPublished(ServerConfiguration.class)).getConfiguration().getProperty("licenceKey"));
            data.stream().map(RedAppRestHelper::toRedAppCounterItem).forEach(request.getItems()::add);
            SynchronizationRequest r = new SynchronizationRequest();
            r.setUser("RedAppCounterUser");
            r.setOperationId(SendRedAppCounterDataRequest.class.getSimpleName());
            r.setClientId(Environment.getApplicationId());
            r.setData((XSerializable)request);
            SynchronizationResponse response = SynchronizationHelper.execute((SynchronizationRequest)r, (String)Address.getSync(), null);
            Message errorMessage = response.getMessages().stream().filter(m -> m.getType() == MessageType.ERROR).findFirst().orElse(null);
            if (errorMessage != null) {
                String mes = logPrefix + "error in response: " + errorMessage.getMessage().toString();
                log.error(mes);
                return;
            }
            if (response.getData() != null && ((SendRedAppCounterDataResponse)response.getData()).isRedAppCounterIsDisabled()) {
                log.debug(logPrefix + "redApp counter is disabled");
            }
            log.debug(logPrefix + "successfully sent");
            data.forEach(arg_0 -> ((AssetsStorage)AssetsStorage.get()).delete(arg_0));
            log.debug(logPrefix + "items deleted");
        }
        catch (Exception e) {
            log.error(logPrefix + "failed", (Throwable)e);
        }
    }
}

