/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.checkFop;

import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.redapp.sws.FOP;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.PriceQuote;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPAviaPropertySet;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPFilteringCategories;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappAction;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RedAppCheckFopUtils {
    public static Set<RuleFilteringCategory> getCategories(RedappAction action) {
        HashSet<RuleFilteringCategory> result = new HashSet<RuleFilteringCategory>();
        switch (action) {
            case END_OF_PNR: {
                result.add((RuleFilteringCategory)FOPFilteringCategories.FOP_END_PNR_CATEGORY_WARNING);
                result.add((RuleFilteringCategory)FOPFilteringCategories.FOP_END_PNR_CATEGORY_MANDATORY);
                break;
            }
            case TICKETING: {
                result.add((RuleFilteringCategory)FOPFilteringCategories.FOP_TICKETING_CATEGORY_MANDATORY);
            }
        }
        return result;
    }

    public static void initProperties(FOPAviaPropertySet set, Itinerary itinerary, Organization agency, List<Integer> pqNumbers) {
        set.setDate(new Date());
        set.getFopTypes().addAll(itinerary.getFops().stream().map(r -> RedAppCheckFopUtils.convertFopType(r.getType())).collect(Collectors.toList()));
        HashSet cards = new HashSet();
        itinerary.getFops().stream().filter(f -> f.getType() == FOP.Type.CARD_AGENCY || f.getType() == FOP.Type.CARD_VENDOR || f.getCard() != null).forEach(f -> {
            set.getCardTypes().add(RedAppCheckFopUtils.convertCardType(f.getCard().getCode()));
            if (f.getCard().getNumber() != null && f.getCard().getNumber().length() > 4) {
                cards.add(f.getCard());
            }
        });
        set.getPQTotals().addAll(itinerary.getPriceQuotes().stream().filter(p -> pqNumbers.isEmpty() || pqNumbers.contains(p.getRph())).map(PriceQuote::getTotalFare).collect(Collectors.toSet()));
        set.getSpecialFares().addAll(itinerary.getPriceQuotes().stream().filter(p -> pqNumbers.isEmpty() || pqNumbers.contains(p.getRph())).filter(pq -> pq.getSpecialFare() != null).map(pq -> new MiscUtil.Pair((Object)pq.getSpecialFare().isPrywatny(), (Object)pq.getSpecialFare().getAccountCodes())).collect(Collectors.toSet()));
        set.getRemarks().addAll(RedAppUtils.getBypassAckRemarks((Itinerary)itinerary));
        set.getValidatingCarriers().addAll(RedAppUtils.getValidatingCarriers((Itinerary)itinerary));
        if (agency == null || cards.isEmpty() || !set.getFopTypes().contains(PaymentType.CREDIT_CARD.name()) && !set.getFopTypes().contains(PaymentType.CREDIT_CARD_AGENCY.name())) {
            set.getCardTypes().clear();
            return;
        }
        set.setAgencyCard(Boolean.valueOf(agency.getCards().stream().filter(Objects::nonNull).anyMatch(c -> {
            if (c.getExpiration() == null || c.getVendor() == null || c.getNumber() == null) {
                return false;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(c.getExpiration());
            return cards.stream().anyMatch(cd -> c.getNumber().endsWith(cd.getNumber().substring(cd.getNumber().length() - 4)) && c.getVendor().name().equals(RedAppCheckFopUtils.convertCardType(cd.getCode())) && cd.getExpMonth() != null && cd.getExpYear() != null && cal.get(1) == cd.getExpYear().intValue() && cal.get(2) + 1 == cd.getExpMonth());
        })));
    }

    private static String convertFopType(FOP.Type type) {
        return RedAppCheckFopUtils.convertFopType(type.name());
    }

    private static String convertFopType(String type) {
        switch (type) {
            case "CHECK": {
                return PaymentType.INVOICE.name();
            }
            case "CASH": {
                return PaymentType.CASH.name();
            }
            case "CARD_VENDOR": {
                return PaymentType.CREDIT_CARD.name();
            }
            case "CARD_AGENCY": {
                return PaymentType.CREDIT_CARD_AGENCY.name();
            }
        }
        return null;
    }

    private static String convertCardType(String type) {
        switch (type) {
            case "VI": {
                return CardVendor.VISA.name();
            }
            case "CA": {
                return CardVendor.MASTERCARD.name();
            }
            case "AX": {
                return CardVendor.AMEX.name();
            }
            case "JC": {
                return CardVendor.JCB.name();
            }
            case "DC": {
                return CardVendor.DINERS_CLUB.name();
            }
            case "TP": {
                return CardVendor.AIR_TRAVEL_CARD.name();
            }
            case "MR": {
                return CardVendor.MIR.name();
            }
        }
        return null;
    }
}

