/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.checkFop.service;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.forOfPayment.OrganizationFOPCheckRules;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPActionResult;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPAviaPropertySet;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPTargets;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.FOPRulesHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import com.gridnine.xtrip.server.web.redapp.checkFop.RedAppCheckFopUtils;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappButton;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessage;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ApplyCheckFopRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Itinerary itinerary = (Itinerary)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.ITINERARY);
        Set categories = (Set)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_FILTERING_CATEGORY);
        List messages = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_MESSAGES);
        EntityContainer agency = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_AGENCY_CLIENT);
        EntityContainer client = (EntityContainer)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_CLIENT_ORGANIZATION);
        Set fops = (Set)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_FOPS);
        List pqNumbers = (List)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_PQ_NUMBERS);
        if ((client == null || ((Organization)client.getEntity()).getFopCheckRules() == null) && ((Organization)agency.getEntity()).getFopCheckRules() == null || itinerary.getFops().isEmpty() && fops.isEmpty()) {
            return;
        }
        if (!fops.isEmpty()) {
            itinerary.getFops().clear();
            itinerary.getFops().addAll(fops);
        }
        EntityContainer clientFopRules = client == null ? null : EntityStorage.get().resolve(((Organization)client.getEntity()).getFopCheckRules());
        EntityContainer agencyFopRules = EntityStorage.get().resolve(((Organization)agency.getEntity()).getFopCheckRules());
        FOPAviaPropertySet set = new FOPAviaPropertySet();
        RedAppCheckFopUtils.initProperties(set, itinerary, (Organization)agency.getEntity(), pqNumbers);
        if (clientFopRules != null) {
            this.processRules(set, categories, (EntityContainer<OrganizationFOPCheckRules>)clientFopRules, messages);
        }
        if (agencyFopRules != null && clientFopRules != agencyFopRules) {
            this.processRules(set, categories, (EntityContainer<OrganizationFOPCheckRules>)agencyFopRules, messages);
        }
    }

    private void processRules(FOPAviaPropertySet set, Set<RuleFilteringCategory> categories, EntityContainer<OrganizationFOPCheckRules> fopCheckRules, List<RedappMessage> messages) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(FOPTargets.FOP_CHECK_RESERVATION.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)set);
        proxy.setActionSet((Object)new FOPActionResult());
        FOPRulesHelper.applyRules((RuleProxy)proxy, (OrganizationFOPCheckRules)((OrganizationFOPCheckRules)fopCheckRules.getEntity()), categories);
        RulesHelper.getAppliedRuleSettings((RuleProxy)proxy, (RuleSet)((OrganizationFOPCheckRules)fopCheckRules.getEntity()).getRuleSet()).forEach(rs -> {
            String title;
            L10nString l10nString = ((FOPActionResult)proxy.getActionSet()).getMessage(rs.getUid());
            if (l10nString != null) {
                title = L10nStringHelper.getValue((L10nString)l10nString, (Locale)LocaleManager.get().getCurrentLocale(), (boolean)true);
                if (title == null) {
                    title = L10nStringHelper.getEnglishValue((L10nString)l10nString);
                }
            } else {
                title = L10nResourcesManager.getStr((String)"FOP_CHECK", (Object[])new Object[0]);
            }
            String text = this.ruleText(fopCheckRules, (RuleSettings)rs);
            if (BooleanUtil.nullAsFalse((Boolean)((FOPActionResult)proxy.getActionSet()).isRestricted(rs.getUid()))) {
                messages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Error, (String)text, (String)title, (String)rs.getUid(), Collections.singletonList(RedappButton.CANCEL)));
            }
            if (BooleanUtil.nullAsFalse((Boolean)((FOPActionResult)proxy.getActionSet()).hasWarning(rs.getUid()))) {
                messages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Warning, (String)text, (String)title, (String)rs.getUid(), Collections.singletonList(RedappButton.CONTINUE)));
            }
            if (!BooleanUtil.nullAsFalse((Boolean)((FOPActionResult)proxy.getActionSet()).isRestricted(rs.getUid())) && !BooleanUtil.nullAsFalse((Boolean)((FOPActionResult)proxy.getActionSet()).hasWarning(rs.getUid()))) {
                messages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Info, (String)text, (String)title, (String)rs.getUid(), Collections.singletonList(RedappButton.CONTINUE)));
            }
        });
    }

    private String ruleText(EntityContainer<OrganizationFOPCheckRules> fopCheckRules, RuleSettings ruleSettings) {
        return String.format("%s (%s), %s (%s)", ((OrganizationFOPCheckRules)fopCheckRules.getEntity()).getName(), fopCheckRules.getUid(), ruleSettings.getName(), ruleSettings.getUid());
    }
}

