/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.checkFop.service;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.redapp.sws.FOP;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.redapp.checkFop.RedAppCheckFopUtils;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.checkFop.service.model.CheckFopParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.BaseParseWebParametersProcessor;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappAction;
import java.util.Set;
import java.util.stream.Collectors;

public class ParseCheckFopParamsProcessor
extends BaseParseWebParametersProcessor {
    public void process(MessageContext ctx) throws Exception {
        super.process(ctx);
        CheckFopParameters parameters = (CheckFopParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        RedappAction action = parameters.getAction();
        Set<RuleFilteringCategory> categories = RedAppCheckFopUtils.getCategories(action);
        if (categories.isEmpty()) {
            throw Xeption.forDeveloper((String)("Unknown action: " + action), (Object[])new Object[0]);
        }
        if (!(action != RedappAction.END_OF_PNR || parameters.getPaymentDetails().isEmpty() && parameters.getPqNumber().isEmpty())) {
            throw Xeption.forDeveloper((String)"FOP types and PQ numbers are not allowed for END_OF_PNR action", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_FILTERING_CATEGORY, categories);
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_FOPS, parameters.getPaymentDetails().stream().map(pd -> {
            FOP fop = new FOP();
            switch (pd.getType()) {
                case "CHECK": {
                    fop.setType(FOP.Type.CHECK);
                    break;
                }
                case "CASH": {
                    fop.setType(FOP.Type.CASH);
                    break;
                }
                case "CARD": {
                    if (pd.getCard().isAutomaticApprovalCode()) {
                        fop.setType(FOP.Type.CARD_VENDOR);
                    } else {
                        fop.setType(FOP.Type.CARD_AGENCY);
                    }
                    FOP.Card card = new FOP.Card();
                    card.setCode(pd.getCard().getCode());
                    card.setNumber(pd.getCard().getNumber());
                    fop.setCard(card);
                }
            }
            return fop;
        }).collect(Collectors.toSet()));
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_PQ_NUMBERS, parameters.getPqNumber().stream().map(Integer::parseInt).collect(Collectors.toList()));
    }
}

