/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.contractCommissions.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.web.redapp.contractCommissions.service.model.RestRedappContractData;
import com.gridnine.xtrip.server.web.redapp.contractCommissions.service.model.RestRedappContractRuleData;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetContractCommissionsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer client = (EntityContainer)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_CLIENT_ORGANIZATION);
        if (client == null) {
            return;
        }
        List contractIndexList = ProfileDao.getSupplierContracts((EntityContainer)client);
        List contractDataList = contractIndexList.stream().filter(ContractIndex::isNewModel).map(this::toRestContractData).filter(Objects::nonNull).collect(Collectors.toList());
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_CONTRACT_DATA_LIST, contractDataList);
    }

    private RestRedappContractData toRestContractData(ContractIndex index) {
        Date now = new Date();
        RestRedappContractData contractData = new RestRedappContractData();
        contractData.setCaption(index.getSource().getCaption());
        EntityContainer contractCtr = EntityStorage.get().resolve(index.getSource());
        List ruleContainers = ProfileHelper.getRuleContainers((EntityContainer)contractCtr, null);
        ruleContainers.stream().flatMap(rc -> ProfileDao.getCommissionsRuleSettingsStream((EntityContainer)rc, (Date)now)).sorted((rs1, rs2) -> {
            if (this.getTargetPriority(rs1.getTarget()) > this.getTargetPriority(rs2.getTarget())) {
                return 1;
            }
            if (this.getTargetPriority(rs1.getTarget()) < this.getTargetPriority(rs2.getTarget())) {
                return -1;
            }
            return MiscUtil.compare((Comparable)((Object)rs1.getTarget().getDisplayName().toUpperCase()), (Comparable)((Object)rs2.getTarget().getDisplayName().toUpperCase()));
        }).map(this::buildRuleData).forEach(contractData.getRules()::add);
        if (!contractData.getRules().isEmpty()) {
            return contractData;
        }
        return null;
    }

    private RestRedappContractRuleData buildRuleData(RuleSettings ruleSettings) {
        RestRedappContractRuleData result = new RestRedappContractRuleData();
        result.setRuleTargetCaption(ruleSettings.getTarget().getDisplayName());
        result.setName(ruleSettings.getName());
        StringBuilder sb = new StringBuilder();
        ruleSettings.buildRestrictionsInfo(sb, false);
        result.setConditions(sb.toString());
        ArrayList commissionsProperties = new ArrayList();
        ArrayList values = new ArrayList();
        ProfileDao.fillCommissionsRuleSettingsData((RuleSettings)ruleSettings, commissionsProperties, values);
        result.setCommissionProperties(TextUtil.join((String)"\n", commissionsProperties));
        result.setValues(TextUtil.join((String)"\n", values));
        return result;
    }

    private int getTargetPriority(RuleTarget target) {
        if (target == Targets.PRODUCT_COMMISSION) {
            return 0;
        }
        if (target == Targets.HOTELS_COMMISSION) {
            return 1;
        }
        return 2;
    }
}

