/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.qualityCheck;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ProfileType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.redapp.sws.EndorsementType;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.PassengerType;
import com.gridnine.xtrip.common.model.redapp.sws.ProfileIndexType;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.redapp.sws.SpecialService;
import com.gridnine.xtrip.common.model.redapp.sws.Ticketing;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TransatlaticRouteHelper;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckPropertySet;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.Endorsement;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappAction;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.TourCode;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RedAppQualityCheckUtils {
    private static final Pattern WEAK_DATE_PATTERN = Pattern.compile("\\$?DOB\\$?");
    private static final Pattern STRONG_DATE_PATTERN = Pattern.compile("\\$?E[OD]/DOB\\d{2}[A-Z]{3}\\d{2}\\$?");

    public static Set<RuleFilteringCategory> getCategories(RedappAction action) {
        HashSet<RuleFilteringCategory> result = new HashSet<RuleFilteringCategory>();
        switch (action) {
            case END_OF_PNR: {
                result.add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_END_PNR_CATEGORY_WARNING);
                result.add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_END_PNR_CATEGORY_MANDATORY);
                break;
            }
            case TICKETING: {
                result.add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_TICKETING_CATEGORY_WARNING);
                result.add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_TICKETING_CATEGORY_MANDATORY);
                break;
            }
            case VOID: {
                result.add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_VOID_CATEGORY_MANDATORY);
                break;
            }
            case EXCHANGE: {
                result.add((RuleFilteringCategory)QualityCheckFilteringCategories.QC_EXCHANGE_CATEGORY_MANDATORY);
            }
        }
        return result;
    }

    public static void initProperties(QualityCheckPropertySet set, Itinerary itinerary, EntityContainer<Organization> client, EntityContainer<Organization> agency, EntityContainer<Person> agent, List<Integer> pqNumbers, TourCode tourCode, Endorsement endorsement, String ticketNumber) {
        set.getValidatingCarriers().addAll(RedAppUtils.getValidatingCarriers((Itinerary)itinerary));
        set.getOperatingCarriers().addAll(RedAppUtils.getOperatingCarriers((Itinerary)itinerary));
        set.getMarketingCarriers().addAll(RedAppUtils.getMarketingCarriers((Itinerary)itinerary));
        set.getOsiCarriers().addAll(itinerary.getOsis().stream().map(SpecialService::getAirlineCode).collect(Collectors.toSet()));
        set.getRemarks().addAll(RedAppUtils.getBypassAckRemarks((Itinerary)itinerary));
        set.getSpecialFares().addAll(itinerary.getPriceQuotes().stream().filter(p -> pqNumbers.isEmpty() || pqNumbers.contains(p.getRph())).filter(pq -> pq.getSpecialFare() != null).map(pq -> new MiscUtil.Pair((Object)pq.getSpecialFare().isPrywatny(), (Object)pq.getSpecialFare().getAccountCodes())).collect(Collectors.toSet()));
        if (TextUtil.nonBlank((String)ticketNumber)) {
            set.setTicketingPcc((String)itinerary.getTicketing().stream().filter(t -> MiscUtil.equals((Object)ticketNumber, (Object)t.getTicketNumber())).map(Ticketing::getPcc).findFirst().orElse(null));
        }
        HashSet pqs = new HashSet();
        HashSet prefixes = new HashSet();
        ValueHolder fareTourCode = new ValueHolder();
        itinerary.getPriceQuotes().stream().filter(p -> pqNumbers.isEmpty() || pqNumbers.contains(p.getRph())).filter(p -> TextUtil.nonBlank((String)p.getTourCode())).forEach(p -> {
            String pqTourCode = p.getTourCode();
            MiscUtil.Pair<String, String> pair = RedAppQualityCheckUtils.parsePqCommand(p.getPqCommand());
            if (pair == null) {
                fareTourCode.setValue((Object)pqTourCode);
                return;
            }
            prefixes.add(pair.getFirst());
            if (!TextUtil.isSame((String)pqTourCode, (String)((String)pair.getSecond()))) {
                fareTourCode.setValue((Object)pqTourCode);
            } else {
                pqs.add(pair.getSecond());
            }
        });
        if (tourCode == null || TextUtil.isBlank((String)tourCode.getType())) {
            set.getTourCodeTypes().addAll(prefixes);
        } else {
            set.getTourCodeTypes().add(RedAppQualityCheckUtils.convertPrefix(tourCode.getType()));
        }
        if (TextUtil.isBlank((String)((String)fareTourCode.getValue()))) {
            if (tourCode == null || TextUtil.isBlank((String)tourCode.getValue())) {
                set.getTourCodes().addAll(pqs);
            } else {
                set.getTourCodes().add(tourCode.getValue());
            }
        } else {
            set.getTourCodes().add(fareTourCode.getValue());
        }
        set.setHasBirthDate(true);
        itinerary.getPriceQuotes().stream().filter(p -> pqNumbers.isEmpty() || pqNumbers.contains(p.getRph())).forEach(p -> {
            PassengerType type = PassengerType.ofCode((String)p.getPassengerType());
            if (set.hasBirthDate()) {
                boolean isNotAdult;
                boolean bl = isNotAdult = type == PassengerType.CHILD || type == PassengerType.INFANT || type == PassengerType.INFANT_WITH_SEAT || p.getTravelers().stream().anyMatch(t -> t.getPassengerType() == PassengerType.CHILD || t.getPassengerType() == PassengerType.INFANT || t.getPassengerType() == PassengerType.INFANT_WITH_SEAT) || itinerary.getSsrs().stream().filter(s -> s.getAssociatedPassengerNumbers().stream().anyMatch(n -> p.getTravelers().stream().anyMatch(t -> MiscUtil.equals((Object)t.getSabreNameNumber(), (Object)n, (boolean)false)))).map(SpecialService::getCode).anyMatch(c -> "CHLD".equals(c) || "INFT".equals(c) || "INST".equals(c));
                if (isNotAdult) {
                    String pp = endorsement != null && endorsement.isOverride() ? endorsement.getValue() : (String)p.getEndorsements().stream().filter(e -> e.getType() == EndorsementType.PRICING_PARAMETER).map(com.gridnine.xtrip.common.model.redapp.sws.Endorsement::getText).findFirst().orElse(null);
                    boolean has = false;
                    if (TextUtil.nonBlank((String)pp)) {
                        if (WEAK_DATE_PATTERN.matcher(pp).find()) {
                            has = itinerary.getSsrs().stream().filter(s -> s.getAssociatedPassengerNumbers().stream().anyMatch(n -> p.getTravelers().stream().anyMatch(t -> MiscUtil.equals((Object)t.getSabreNameNumber(), (Object)n, (boolean)false)))).anyMatch(s -> "DOCS".equals(s.getCode()) && !"DB".equals(s.getDocType()));
                        } else if (STRONG_DATE_PATTERN.matcher(pp).find()) {
                            has = true;
                        }
                    }
                    if (!has && endorsement != null && !endorsement.isOverride() && TextUtil.nonBlank((String)endorsement.getValue())) {
                        if (WEAK_DATE_PATTERN.matcher(endorsement.getValue()).find()) {
                            has = itinerary.getSsrs().stream().filter(s -> s.getAssociatedPassengerNumbers().stream().anyMatch(n -> p.getTravelers().stream().anyMatch(t -> MiscUtil.equals((Object)t.getSabreNameNumber(), (Object)n, (boolean)false)))).anyMatch(s -> "DOCS".equals(s.getCode()) && !"DB".equals(s.getDocType()));
                        } else if (STRONG_DATE_PATTERN.matcher(endorsement.getValue()).find()) {
                            has = true;
                        }
                    }
                    if (!has) {
                        has = itinerary.getOsis().stream().filter(s -> s.getAssociatedPassengerNumbers().stream().anyMatch(n -> p.getTravelers().stream().anyMatch(t -> MiscUtil.equals((Object)t.getSabreNameNumber(), (Object)n, (boolean)false)))).anyMatch(o -> o.getFreeText() != null && o.getFreeText().startsWith("PSPT"));
                    }
                    if (!has) {
                        set.setHasBirthDate(false);
                    }
                }
            }
        });
        RedAppUtils.initLocations((BasicAirTicketPropertiesProvider)set, (Itinerary)itinerary);
        RedAppQualityCheckUtils.initOsiProperties(set, itinerary, client);
        RedAppQualityCheckUtils.initOsiProperties(set, itinerary, agency);
        set.setOsi(set.getOsis().isEmpty());
        if (itinerary.getPassengers().stream().anyMatch(p -> p.getSabreProfileIndex() != null && p.getSabreProfileIndex().getType() == ProfileIndexType.TRAVELER)) {
            set.getProfileTypes().add(ProfileType.TRAVELER);
        }
        if (itinerary.getAgencies().stream().anyMatch(a -> a.getType() == ProfileIndexType.TAGENCY)) {
            set.getProfileTypes().add(ProfileType.TAGENCY);
        }
        if (itinerary.getCorporants().stream().anyMatch(a -> a.getType() == ProfileIndexType.CORPID)) {
            set.getProfileTypes().add(ProfileType.CORPID);
        }
        set.getBookingClasses().addAll(RedAppUtils.getBookingClasses((Itinerary)itinerary));
        set.setSsrDocsDb(itinerary.getSsrs().stream().anyMatch(s -> "DOCS".equals(s.getCode())));
        if (set.hasSsrDocsDb()) {
            set.setSsrDocs(itinerary.getSsrs().stream().anyMatch(s -> "DOCS".equals(s.getCode()) && !"DB".equals(s.getDocType())));
        }
        set.setHasPassengerContact(itinerary.getPassengers().stream().allMatch(p -> itinerary.getSsrs().stream().anyMatch(ss -> "CTCE".equals(ss.getCode()) && ss.getAssociatedPassengerNumbers().contains(p.getSabreNameNumber())) && itinerary.getSsrs().stream().anyMatch(ss -> "CTCM".equals(ss.getCode()) && ss.getAssociatedPassengerNumbers().contains(p.getSabreNameNumber()))));
        set.setHasAgentCodeRemarks(((Organization)agency.getEntity()).getRedappSettings().getAgentCodeRemarkTemplates().stream().filter(TextUtil::nonBlank).anyMatch(rt -> itinerary.getRemarks().stream().filter(r -> RedAppUtils.remarkTypes.contains(r.getType())).map(r -> Pattern.compile(rt.replaceAll("\\.", "\\\\.") + "(.+)").matcher(RedAppUtils.getPrefix((RemarkType)r.getType()) + r.getText())).anyMatch(m -> m.matches())));
        set.getAgentCodeRemarks().addAll(((Organization)agency.getEntity()).getRedappSettings().getAgentCodeRemarkTemplates().stream().filter(TextUtil::nonBlank).map(rt -> {
            MiscUtil.Pair pair = RedAppUtils.getRemarkTypeTextPair((String)rt);
            if (pair != null) {
                return new Remark((String)pair.getSecond() + (ValidationUtil.containsNonAlphaNumeric((String)((String)pair.getSecond()).substring(((String)pair.getSecond()).length() - 1)) ? "" : " ") + ((Person)agent.getEntity()).getCode(), null, (RemarkType)pair.getFirst());
            }
            return null;
        }).collect(Collectors.toSet()));
        set.setTransatlantic(itinerary.getAirSegments().stream().anyMatch(s -> TransatlaticRouteHelper.isTransatlanticSegment((String)s.getDepartureLocation(), (String)s.getArrivalLocation(), (Date)DateUtils.toJavaDate((LocalDateTime)s.getDepartureDateTime()), (Date)DateUtils.toJavaDate((LocalDateTime)s.getArrivalDateTime()), (Integer)s.getFlightDurationInMinutes())));
        set.setHasLuggage(itinerary.getAirSegments().stream().anyMatch(as -> as.getBaggage() != null && !"NIL".equals(as.getBaggage().getAllowance())));
    }

    private static MiscUtil.Pair<String, String> parsePqCommand(String pqCommand) {
        String[] commands;
        if (!pqCommand.startsWith("WP")) {
            return null;
        }
        Pattern pattern = Pattern.compile("(?<prefix>U([BINX]\\*)?)(?<tourCode>[A-Z0-9]+)");
        for (String command : commands = pqCommand.substring(2).split("\\$")) {
            Matcher matcher = pattern.matcher(command);
            if (!matcher.matches()) continue;
            return new MiscUtil.Pair((Object)RedAppQualityCheckUtils.convertPrefix(matcher.group("prefix")), (Object)matcher.group("tourCode"));
        }
        return null;
    }

    private static String convertPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        switch (prefix) {
            case "U": {
                return TripartiteContractCalculationIndicatorType.INDICATOR_Z.name();
            }
            case "UI": 
            case "UI*": {
                return TripartiteContractCalculationIndicatorType.INDICATOR_I.name();
            }
            case "UB": 
            case "UB*": {
                return TripartiteContractCalculationIndicatorType.INDICATOR_B.name();
            }
            case "UN": 
            case "UN*": {
                return TripartiteContractCalculationIndicatorType.INDICATOR_N.name();
            }
            case "UX": 
            case "UX*": {
                return TripartiteContractCalculationIndicatorType.INDICATOR_X.name();
            }
        }
        return null;
    }

    private static void initOsiProperties(QualityCheckPropertySet set, Itinerary itinerary, EntityContainer<Organization> org) {
        HashSet osis = new HashSet();
        if (org != null) {
            osis.addAll(((Organization)org.getEntity()).getSabreAdditionalCommand2Lines().stream().filter(o -> "YY".equals(o.getEntry1()) || set.getMarketingCarriers().contains(o.getEntry1())).filter(o -> itinerary.getOsis().stream().noneMatch(os -> (os.getAirlineCode().equals(o.getEntry1()) || "YY".equals(os.getAirlineCode()) || "YY".equals(o.getEntry1()) && set.getMarketingCarriers().size() == 1) && os.getFreeText().equals(o.getEntry2()))).collect(Collectors.toSet()));
        }
        set.getOsis().addAll(osis);
    }
}

