/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.qualityCheck.service;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.qualityCheck.OrganizationQualityCheckRules;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckActionResult;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckPropertySet;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckTargets;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.QualityCheckRulesHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import com.gridnine.xtrip.server.web.redapp.qualityCheck.RedAppQualityCheckUtils;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.Endorsement;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappButton;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessage;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RestConfirmation;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.TourCode;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class ApplyQualityCheckRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Itinerary itinerary = (Itinerary)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.ITINERARY);
        Set categories = (Set)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_FILTERING_CATEGORY);
        List messages = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_MESSAGES);
        EntityContainer agent = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_AGENT);
        EntityContainer agency = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_AGENCY_CLIENT);
        EntityContainer client = (EntityContainer)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_CLIENT_ORGANIZATION);
        List pqNumbers = (List)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_PQ_NUMBERS);
        TourCode tourCode = (TourCode)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_TOUR_CODE);
        Endorsement endorsement = (Endorsement)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_ENDORSEMENT);
        List confirmations = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_CONFIRMATIONS);
        String currentPcc = (String)ctx.getObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_CURRENT_PCC);
        String ticketNumber = (String)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_TICKET_NUMBER);
        if ((client == null || ((Organization)client.getEntity()).getQualityCheckRules() == null) && ((Organization)agency.getEntity()).getQualityCheckRules() == null) {
            return;
        }
        EntityContainer clientQCRules = client == null ? null : EntityStorage.get().resolve(((Organization)client.getEntity()).getQualityCheckRules());
        EntityContainer agencyQCRules = EntityStorage.get().resolve(((Organization)agency.getEntity()).getQualityCheckRules());
        QualityCheckPropertySet set = new QualityCheckPropertySet();
        set.setCurrentPcc(currentPcc);
        RedAppQualityCheckUtils.initProperties(set, itinerary, (EntityContainer<Organization>)client, (EntityContainer<Organization>)agency, (EntityContainer<Person>)agent, pqNumbers, tourCode, endorsement, ticketNumber);
        if (clientQCRules != null) {
            this.processRules(set, categories, (EntityContainer<OrganizationQualityCheckRules>)clientQCRules, messages, confirmations, ctx);
        }
        if (agencyQCRules != null && clientQCRules != agencyQCRules) {
            this.processRules(set, categories, (EntityContainer<OrganizationQualityCheckRules>)agencyQCRules, messages, confirmations, ctx);
        }
        if (ctx.hasObject((Enum)IBusGdsSabreContextKeys.OSIS)) {
            Set osis = (Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.OSIS);
            this.clearOsis(osis);
        }
        if (ctx.hasObject((Enum)IBusGdsSabreContextKeys.OSIS) || ctx.hasObject((Enum)IBusGdsSabreContextKeys.REMARKS)) {
            ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_UPDATE_PNR, (Object)true);
        }
    }

    private void processRules(QualityCheckPropertySet set, Set<RuleFilteringCategory> categories, EntityContainer<OrganizationQualityCheckRules> qcCheckRules, List<RedappMessage> messages, List<RestConfirmation> confirmations, MessageContext ctx) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)set);
        proxy.setActionSet((Object)new QualityCheckActionResult());
        QualityCheckRulesHelper.applyRules((RuleProxy)proxy, (OrganizationQualityCheckRules)((OrganizationQualityCheckRules)qcCheckRules.getEntity()), categories);
        RulesHelper.getAppliedRuleSettings((RuleProxy)proxy, (RuleSet)((OrganizationQualityCheckRules)qcCheckRules.getEntity()).getRuleSet()).forEach(rs -> {
            String title;
            L10nString l10nString;
            boolean needConfirm = false;
            HashSet<SabreProfileCommand2Osi> osis = new HashSet<SabreProfileCommand2Osi>(set.getOsis());
            if (((QualityCheckActionResult)proxy.getActionSet()).getOsiCarriers(rs.getUid()) != null) {
                osis.removeIf(o -> !((QualityCheckActionResult)proxy.getActionSet()).getOsiCarriers(rs.getUid()).contains(o.getEntry1()));
            }
            if (BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isAddOSI(rs.getUid())) && !osis.isEmpty()) {
                if (BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isConfirmAddOSI(rs.getUid())) && confirmations.stream().noneMatch(c -> rs.getUid().equals(c.getRuleUid()) && c.isConfirm())) {
                    needConfirm = true;
                } else if (ctx.hasObject((Enum)IBusGdsSabreContextKeys.OSIS)) {
                    ((Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.OSIS)).addAll(new HashSet(osis));
                } else {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.OSIS, new HashSet(osis));
                }
            }
            if (BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isAddMissingAgentCodeRemarks(rs.getUid())) && !set.getAgentCodeRemarks().isEmpty()) {
                if (BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isConfirmAddMissingAgentCodeRemarks(rs.getUid())) && confirmations.stream().noneMatch(c -> rs.getUid().equals(c.getRuleUid()) && c.isConfirm())) {
                    needConfirm = true;
                } else {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.REMARKS, new HashSet(set.getAgentCodeRemarks()));
                }
            }
            if ((l10nString = ((QualityCheckActionResult)proxy.getActionSet()).getMessage(rs.getUid())) != null) {
                title = L10nStringHelper.getValue((L10nString)l10nString, (Locale)LocaleManager.get().getCurrentLocale(), (boolean)true);
                if (title == null) {
                    title = L10nStringHelper.getEnglishValue((L10nString)l10nString);
                }
            } else {
                title = L10nResourcesManager.getStr((String)(needConfirm ? "QUALITY_CHECK_UPDATE_PNR" : "QUALITY_CHECK"), (Object[])new Object[0]);
            }
            HashSet<RedappButton> buttons = new HashSet<RedappButton>();
            if (needConfirm) {
                buttons.add(RedappButton.UPDATE);
            }
            String text = this.ruleText(qcCheckRules, (RuleSettings)rs);
            if (BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isEndPnrProhibited(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isTicketingProhibited(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isVoidProhibited(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isExchangeReissueProhibited(rs.getUid()))) {
                buttons.add(RedappButton.CANCEL);
                messages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Error, (String)text, (String)title, (String)rs.getUid(), buttons));
            }
            if (BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).hasWarning(rs.getUid()))) {
                buttons.add(RedappButton.CONTINUE);
                messages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Warning, (String)text, (String)title, (String)rs.getUid(), buttons));
            }
            if (!(BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isEndPnrProhibited(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isTicketingProhibited(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).hasWarning(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isVoidProhibited(rs.getUid())) || BooleanUtil.nullAsFalse((Boolean)((QualityCheckActionResult)proxy.getActionSet()).isExchangeReissueProhibited(rs.getUid())))) {
                buttons.add(RedappButton.CONTINUE);
                messages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Info, (String)text, (String)title, (String)rs.getUid(), buttons));
            }
        });
    }

    private String ruleText(EntityContainer<OrganizationQualityCheckRules> qcCheckRules, RuleSettings ruleSettings) {
        return String.format("%s (%s), %s (%s)", ((OrganizationQualityCheckRules)qcCheckRules.getEntity()).getName(), qcCheckRules.getUid(), ruleSettings.getName(), ruleSettings.getUid());
    }

    private void clearOsis(Set<SabreProfileCommand2Osi> osis) {
        HashSet<SabreProfileCommand2Osi> copy = new HashSet<SabreProfileCommand2Osi>(osis);
        for (SabreProfileCommand2Osi osi : copy) {
            Set dups;
            if (!osis.contains(osi) || (dups = osis.stream().filter(o -> TextUtil.isSame((String)o.getEntry2(), (String)osi.getEntry2(), (boolean)true, (boolean)true)).collect(Collectors.toSet())).size() == 1) continue;
            SabreProfileCommand2Osi keep = dups.stream().filter(o -> "YY".equals(o.getEntry1())).findFirst().orElse(null);
            if (keep != null) {
                dups.remove(keep);
                osis.removeAll(dups);
                continue;
            }
            Set trueDups = dups.stream().filter(o -> TextUtil.isSame((String)o.getEntry1(), (String)osi.getEntry1(), (boolean)true, (boolean)true)).collect(Collectors.toSet());
            if (trueDups.size() == 1) continue;
            trueDups.stream().skip(1L).forEach(osis::remove);
        }
    }
}

