/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.qualityCheck.service;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappButton;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CheckSuccessRemarksUpdate
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Set remarks = (Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.REMARKS);
        Itinerary itinerary = (Itinerary)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.ITINERARY);
        List updateMessages = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_UPDATE_MESSAGES);
        List messages = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_MESSAGES);
        messages.clear();
        StringBuilder sb = new StringBuilder();
        itinerary.getRemarks().forEach(r -> {
            Remark remark = remarks.stream().filter(rm -> r.getType() == rm.getType() && TextUtil.isSame((String)r.getText(), (String)rm.getText(), (boolean)true)).findFirst().orElse(null);
            if (remark != null) {
                remarks.remove(remark);
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append("5").append(RedAppUtils.getPrefix((RemarkType)r.getType())).append(r.getText());
            }
        });
        if (!remarks.isEmpty()) {
            updateMessages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Warning, (String)remarks.stream().map(Remark::getText).collect(Collectors.joining("\n")), (String)L10nResourcesManager.getStr((String)"QUALITY_CHECK_ADD_REMARKS_FAILED", (Object[])new Object[0]), null, Collections.singleton(RedappButton.CONTINUE)));
        } else {
            updateMessages.add(RedAppUtils.buildMessage((RedappMessageType)RedappMessageType.Info, (String)sb.toString(), (String)L10nResourcesManager.getStr((String)"QUALITY_CHECK_ADD_REMARKS", (Object[])new Object[0]), null, Collections.singleton(RedappButton.CONTINUE)));
        }
    }
}

