/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.qualityCheck.service;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.qualityCheck.OrganizationQualityCheckRules;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckProperties;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class NeedCurrentPccKeyProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        if (ctx.hasObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_CURRENT_PCC)) {
            return "false";
        }
        Set categories = (Set)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_FILTERING_CATEGORY);
        EntityContainer agency = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_AGENCY_CLIENT);
        EntityContainer client = (EntityContainer)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_CLIENT_ORGANIZATION);
        if ((client == null || ((Organization)client.getEntity()).getQualityCheckRules() == null) && ((Organization)agency.getEntity()).getQualityCheckRules() == null) {
            return "false";
        }
        EntityContainer clientQCRules = client == null ? null : EntityStorage.get().resolve(((Organization)client.getEntity()).getQualityCheckRules());
        EntityContainer agencyQCRules = EntityStorage.get().resolve(((Organization)agency.getEntity()).getQualityCheckRules());
        if (clientQCRules != null && this.checkRules(((OrganizationQualityCheckRules)clientQCRules.getEntity()).getRuleSet().getRules(), categories)) {
            return "true";
        }
        if (agencyQCRules != null && this.checkRules(((OrganizationQualityCheckRules)agencyQCRules.getEntity()).getRuleSet().getRules(), categories)) {
            return "true";
        }
        return "false";
    }

    private boolean checkRules(List<RuleSettings> rules, Set<RuleFilteringCategory> categories) {
        return rules.stream().filter(rs -> !(!categories.contains(rs.getFilteringCategory()) || rs.getPeriodBegin() != null && rs.getPeriodBegin().after(new Date()) || rs.getPeriodEnd() != null && rs.getPeriodEnd().before(new Date()))).anyMatch(r -> r.getRestrictions().stream().anyMatch(rt -> rt.getProperty() == QualityCheckProperties.BOOKING_PCC || rt.getProperty() == QualityCheckProperties.TICKETING_PCC || rt.getProperty() == QualityCheckProperties.EXCHANGE_PCC_MATCHES_TICKETING_PCC));
    }
}

