/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.qualityCheck.service;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.redapp.qualityCheck.RedAppQualityCheckUtils;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.qualityCheck.service.model.QualityCheckParameters;
import com.gridnine.xtrip.server.web.rest.redapp.service.BaseParseWebParametersProcessor;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappAction;
import java.util.Set;
import java.util.stream.Collectors;

public class ParseQualityCheckParamsProcessor
extends BaseParseWebParametersProcessor {
    public void process(MessageContext ctx) throws Exception {
        super.process(ctx);
        QualityCheckParameters parameters = (QualityCheckParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        RedappAction action = parameters.getAction();
        Set<RuleFilteringCategory> categories = RedAppQualityCheckUtils.getCategories(action);
        if (categories.isEmpty()) {
            throw Xeption.forDeveloper((String)("Unknown action: " + action), (Object[])new Object[0]);
        }
        if (!(action == RedappAction.TICKETING || parameters.getTourCode() == null && parameters.getPqNumber().isEmpty())) {
            throw Xeption.forDeveloper((String)"Tour code and PQ numbers are only allowed for TICKETING action", (Object[])new Object[0]);
        }
        if (action == RedappAction.EXCHANGE && TextUtil.isBlank((String)parameters.getTicketNumber())) {
            throw Xeption.forDeveloper((String)"No ticket number for EXCHANGE action", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_TOUR_CODE, (Object)parameters.getTourCode());
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_ENDORSEMENT, (Object)parameters.getEndorsement());
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_PQ_NUMBERS, parameters.getPqNumber().stream().map(Integer::parseInt).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REST_REDAPP_CONFIRMATIONS, (Object)parameters.getConfirmations());
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_FILTERING_CATEGORY, categories);
        ctx.putObject((Enum)IBusRestRedAppContextKeys.REDAPP_TICKET_NUMBER, (Object)parameters.getTicketNumber());
    }
}

