/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.travelPolicy;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TransatlaticRouteHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules.RedAppTravelPolicyPropertySet;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.stream.Collectors;

public class RedAppTravelPolicyUtils {
    public static void initProperties(RedAppTravelPolicyPropertySet set, Itinerary itinerary, EntityContainer<Organization> agency, EntityContainer<Organization> client) {
        set.getAirlines().addAll(RedAppUtils.getMarketingCarriers((Itinerary)itinerary));
        RedAppUtils.initLocations((BasicAirTicketPropertiesProvider)set, (Itinerary)itinerary);
        set.setTransatlantic(itinerary.getAirSegments().stream().anyMatch(s -> TransatlaticRouteHelper.isTransatlanticSegment((String)s.getDepartureLocation(), (String)s.getArrivalLocation(), (Date)DateUtils.toJavaDate((LocalDateTime)s.getDepartureDateTime()), (Date)DateUtils.toJavaDate((LocalDateTime)s.getArrivalDateTime()), (Integer)s.getFlightDurationInMinutes())));
        if (((Organization)agency.getEntity()).getRedappSettings() != null) {
            set.getRemarks().addAll(RedAppUtils.getBypassAckRemarks((Itinerary)itinerary).stream().filter(r -> TextUtil.isSame((String)r, (String)((Organization)agency.getEntity()).getRedappSettings().getAuthApprovalRemarkTemplate(), (boolean)true)).collect(Collectors.toSet()));
        }
        if (client != null && ((Organization)client.getEntity()).getRedappSettings() != null) {
            set.getRemarks().addAll(RedAppUtils.getBypassAckRemarks((Itinerary)itinerary).stream().filter(r -> TextUtil.isSame((String)r, (String)((Organization)client.getEntity()).getRedappSettings().getAuthApprovalRemarkTemplate(), (boolean)true)).collect(Collectors.toSet()));
        }
    }
}

