/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.travelPolicy.service;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.RedAppTravelPolicyUtils;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules.RedAppTravelPolicyActionResult;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules.RedAppTravelPolicyPropertySet;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules.RedAppTravelPolicyRulesHelper;
import com.gridnine.xtrip.server.web.rest.redapp.IBusRestRedAppContextKeys;
import com.gridnine.xtrip.server.web.rest.redapp.RedAppUtils;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappButton;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessage;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class ApplyTravelPolicyRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Itinerary itinerary = (Itinerary)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.ITINERARY);
        List messages = (List)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_MESSAGES);
        EntityContainer agency = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestRedAppContextKeys.REDAPP_AGENCY_CLIENT);
        EntityContainer client = (EntityContainer)ctx.getObject((Enum)IBusRestRedAppContextKeys.REDAPP_CLIENT_ORGANIZATION);
        if ((client == null || ((Organization)client.getEntity()).getIbeTravelPolicy() == null) && ((Organization)agency.getEntity()).getIbeTravelPolicy() == null) {
            return;
        }
        EntityContainer clientTPRules = client == null ? null : EntityStorage.get().resolve(((Organization)client.getEntity()).getIbeTravelPolicy());
        EntityContainer agencyTPRules = EntityStorage.get().resolve(((Organization)agency.getEntity()).getIbeTravelPolicy());
        RedAppTravelPolicyPropertySet set = new RedAppTravelPolicyPropertySet();
        RedAppTravelPolicyUtils.initProperties(set, itinerary, (EntityContainer<Organization>)agency, (EntityContainer<Organization>)client);
        if (clientTPRules != null) {
            this.processRules(set, (EntityContainer<OrganizationTravelPolicy>)clientTPRules, messages, ctx);
        }
        if (agencyTPRules != null) {
            this.processRules(set, (EntityContainer<OrganizationTravelPolicy>)agencyTPRules, messages, ctx);
        }
    }

    private void processRules(RedAppTravelPolicyPropertySet set, EntityContainer<OrganizationTravelPolicy> tpRules, List<RedappMessage> messages, MessageContext ctx) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)set);
        proxy.setActionSet((Object)new RedAppTravelPolicyActionResult());
        RedAppTravelPolicyRulesHelper.applyRules((RuleProxy<? extends RedAppTravelPolicyPropertySet, RedAppTravelPolicyActionResult>)proxy, (OrganizationTravelPolicy)tpRules.getEntity());
        RulesHelper.getAppliedRuleSettings((RuleProxy)proxy, (RuleSet)((OrganizationTravelPolicy)tpRules.getEntity()).getRuleSet()).forEach(rs -> {
            String title;
            RedappMessageType messageType;
            L10nString l10nString = ((RedAppTravelPolicyActionResult)proxy.getActionSet()).getMessage(rs.getUid());
            HashSet<RedappButton> buttons = new HashSet<RedappButton>();
            if (((RedAppTravelPolicyActionResult)proxy.getActionSet()).isProhibitEndPnr(rs.getUid())) {
                messageType = RedappMessageType.Error;
                buttons.add(RedappButton.CANCEL);
            } else if (((RedAppTravelPolicyActionResult)proxy.getActionSet()).isDisplayWarning(rs.getUid())) {
                messageType = RedappMessageType.Warning;
                buttons.add(RedappButton.CONTINUE);
            } else {
                messageType = RedappMessageType.Warning;
                buttons.add(RedappButton.CONTINUE);
            }
            if (l10nString != null) {
                title = L10nStringHelper.getValue((L10nString)l10nString, (Locale)LocaleManager.get().getCurrentLocale(), (boolean)true);
                if (title == null) {
                    title = L10nStringHelper.getEnglishValue((L10nString)l10nString);
                }
            } else {
                TravelPolicyMatchType type = ((RedAppTravelPolicyActionResult)proxy.getActionSet()).getMatchType(rs.getUid());
                title = type == TravelPolicyMatchType.HIDE ? L10nResourcesManager.getStr((String)"TRAVEL_POLICY_HIDE", (Object[])new Object[0]) : (type == TravelPolicyMatchType.VIOLATION ? L10nResourcesManager.getStr((String)"TRAVEL_POLICY_VIOLATION", (Object[])new Object[0]) : (type == TravelPolicyMatchType.STRICT_VIOLATION ? L10nResourcesManager.getStr((String)"TRAVEL_POLICY_STRICT_VIOLATION", (Object[])new Object[0]) : ""));
            }
            String text = this.ruleText(tpRules, (RuleSettings)rs);
            messages.add(RedAppUtils.buildMessage((RedappMessageType)messageType, (String)text, (String)title, (String)rs.getUid(), buttons));
        });
    }

    private String ruleText(EntityContainer<OrganizationTravelPolicy> tpRules, RuleSettings ruleSettings) {
        return String.format("%s (%s), %s (%s)", ((OrganizationTravelPolicy)tpRules.getEntity()).getName(), tpRules.getUid(), ruleSettings.getName(), ruleSettings.getUid());
    }
}

