/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules;

import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActions;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules.RedAppTravelPolicyActionResult;
import com.gridnine.xtrip.server.web.redapp.travelPolicy.service.rules.RedAppTravelPolicyPropertySet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedAppTravelPolicyRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(RedAppTravelPolicyRulesHelper.class);
    private static final Set<RuleProperty> applicableProperties = new HashSet<RuleProperty>();
    private static final Set<RuleAction> applicableActions;

    public static void applyRules(RuleProxy<? extends RedAppTravelPolicyPropertySet, RedAppTravelPolicyActionResult> proxy, OrganizationTravelPolicy rules) throws Exception {
        if (rules == null || rules.getRuleSet() == null || rules.getRuleSet().getRules().isEmpty()) {
            log.info("No rule set to apply");
            return;
        }
        List<RuleSettings> copy = rules.getRuleSet().getRules().stream().map(rs -> {
            try {
                return (RuleSettings)XCloneHelper.clone((XCloneable)rs);
            }
            catch (Exception e) {
                log.error("Failed to copy rule", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        copy.removeIf(r -> !r.getRestrictions().isEmpty() && r.getRestrictions().stream().noneMatch(rr -> applicableProperties.contains(rr.getProperty())));
        copy.removeIf(r -> r.getResults().isEmpty() || r.getResults().stream().noneMatch(rr -> applicableActions.contains(rr.getAction())));
        copy.forEach(rs -> rs.getResults().removeIf(r -> !applicableActions.contains(r.getAction())));
        copy.forEach(rs -> rs.getRestrictions().removeIf(r -> !applicableProperties.contains(r.getProperty())));
        RuleEngine.applyRules(Collections.singletonList(proxy), copy, (RuleResultHandler)new RuleResultHandler(){

            public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                ((RedAppTravelPolicyActionResult)proxy.getActionSet()).setRuleUid(ruleSettings.getUid());
                if (ruleResult.getAction().equals(TravelPolicyActions.TRAVEL_POLICY_MATCH_TYPE)) {
                    ((RedAppTravelPolicyActionResult)proxy.getActionSet()).setMatchType((TravelPolicyMatchType)ruleResult.getValue());
                    proxy.getAppliedRules().add(ruleSettings.getUid());
                }
                proxy.getAppliedRuleCategories().clear();
            }

            public boolean isProcessAllRuleResults() {
                return true;
            }
        });
    }

    static {
        applicableProperties.add((RuleProperty)Properties.AIRLINES);
        applicableProperties.add((RuleProperty)Properties.ROUTE);
        applicableProperties.add((RuleProperty)Properties.NO_AUTH_APPROVED_REMARK);
        applicableActions = new HashSet<RuleAction>();
        applicableActions.add((RuleAction)Actions.DISPLAY_MESSAGE);
        applicableActions.add((RuleAction)TravelPolicyActions.TRAVEL_POLICY_MATCH_TYPE);
        applicableActions.add((RuleAction)TravelPolicyActions.DISPLAY_WARNING_TRAVEL_POLICY_VIOLATION);
        applicableActions.add((RuleAction)TravelPolicyActions.TRAVEL_POLICY_VIOLATION_PROHIBIT_END_PNR);
    }
}

