/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.xstreamws;

import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.HttpInvoker;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.xstreamws.IBusWsContextKeys;
import com.gridnine.xtrip.server.xstreamws.InvocationContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class HttpItemTransactionAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusWsContextKeys.WS_HTTP_INVOKER_START, (Object)System.currentTimeMillis());
    }

    public void after(MessageContext ctx) throws Exception {
        Long startTime = (Long)ctx.getMandatoryObject((Enum)IBusWsContextKeys.WS_HTTP_INVOKER_START);
        long endTime = System.currentTimeMillis();
        HttpRequest request = (HttpRequest)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_REQUEST);
        HttpResponse response = (HttpResponse)ctx.getObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        InvocationContext.get().addTransaction(this.buildTransactionContent(request, response, startTime, endTime));
    }

    private String buildTransactionContent(HttpRequest request, HttpResponse response, long startTime, long endTime) {
        StringBuilder sb = new StringBuilder();
        String url = HttpInvoker.buildUrl((HttpRequest)request);
        sb.append(String.format("<transaction date=\"%s\" timing=\"%s\" url=\"%s\" >", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(startTime)), endTime - startTime, url));
        if (!request.getRequestProperties().isEmpty()) {
            sb.append("<headers>\n");
            for (Map.Entry entry : request.getRequestProperties().entrySet()) {
                sb.append(String.format("<%s>%s</%1$s>", entry.getKey(), entry.getValue()));
            }
            sb.append("</headers>");
        }
        sb.append("<request>");
        if (request.getBody() != null) {
            sb.append(new String(request.getBody()));
        }
        sb.append("</request>");
        if (response != null) {
            sb.append(String.format("<response code=\"%s\" message=\"%s\">", response.getResponseCode(), response.getResponseMessage()));
        } else {
            sb.append("<response>");
        }
        if (response != null && response.getBody() != null) {
            sb.append(new String(response.getBody()));
        }
        sb.append("</response>");
        if (response != null && response.getError() != null) {
            sb.append("<error>");
            sb.append("<![CDATA[");
            sb.append(new String(response.getError()));
            sb.append("]]>");
            sb.append("</error>");
        }
        sb.append("</transaction>");
        return sb.toString();
    }
}

