/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.xstreamws;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationContext {
    private static final ThreadLocal<InvocationContext> INSTANCE = new ThreadLocal<InvocationContext>(){

        @Override
        protected InvocationContext initialValue() {
            return new InvocationContext();
        }
    };
    private final List<String> transactions = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(InvocationContext.class);
    private boolean active;

    public static InvocationContext get() {
        return INSTANCE.get();
    }

    public boolean isActive() {
        return this.active;
    }

    void begin() {
        this.transactions.clear();
        this.active = true;
    }

    void addTransaction(String transaction) {
        if (this.active) {
            this.transactions.add(transaction);
        } else {
            log.warn("addTransaction() ignored because of non-active state, maybe you forgot to wrap your subroute with com.gridnine.xtrip.server.xstreamws.LoggingAdvice ?");
        }
    }

    public Document buildDocument() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<ws-transactions>");
        for (String transaction : this.transactions) {
            sb.append(transaction);
        }
        sb.append("</ws-transactions>");
        Document document = new Document();
        String content = sb.toString();
        try {
            document.setContent(this.prettyFormat(content).getBytes());
            document.setContentType(ContentType.XML);
        }
        catch (Exception e) {
            log.error("format xml failed", (Throwable)e);
            document.setContent(content.getBytes());
            document.setContentType(ContentType.TEXT);
        }
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setCreated(new Date());
        return document;
    }

    void end() {
        this.transactions.clear();
        this.active = false;
    }

    private String prettyFormat(String input) throws Exception {
        StreamSource xmlInput = new StreamSource(new StringReader(input));
        StringWriter stringWriter = new StringWriter();
        StreamResult xmlOutput = new StreamResult(stringWriter);
        Transformer transformer = XUtil.newTransformer();
        transformer.transform(xmlInput, xmlOutput);
        return xmlOutput.getWriter().toString();
    }
}

