/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.xstreamws;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.xstreamws.IBusWsContextKeys;
import com.gridnine.xtrip.server.xstreamws.WsRequest;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class XStreamRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsRequest request = (WsRequest)ctx.getMandatoryObject((Enum)IBusWsContextKeys.WS_XSTREAM_REQUEST);
        if (TextUtil.isBlank((String)request.getEndpointAddress())) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(request.getEndpointAddress());
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.getRequestProperties().putAll(request.getHttpHeaders());
        httpRequest.setConnectTimeout(request.getConnectTimeout());
        httpRequest.setReadTimeout(request.getReadTimeout());
        httpRequest.setUseCaches(request.getUseCaches());
        httpRequest.setUseTrustfulHostnameVerifier(request.isUseTrustfulHostnameVerifier());
        httpRequest.setUseTrustfulManager(request.isUseTrustfulManager());
        httpRequest.setCustomSsocketFactory(request.getCustomSsocketFactory());
        httpRequest.setBody(this.buildBody(request.getHeaders(), request.getPayload(), request.getRequestRootClasses()));
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildBody(List<Object> headers, Object payload, List<Class> types) throws Exception {
        XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver((NameCoder)new NoNameCoder()));
        xstream.processAnnotations(types.toArray(new Class[types.size()]));
        xstream.setMode(1001);
        StringBuilder sb = new StringBuilder();
        sb.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        sb.append("<SOAP-ENV:Header>");
        for (Object header : headers) {
            try (StringWriter sw = new StringWriter();
                 CompactWriter cw = new CompactWriter((Writer)sw);){
                xstream.marshal(header, (HierarchicalStreamWriter)cw);
            }
            sb.append(sw.toString());
        }
        sb.append("</SOAP-ENV:Header>");
        sb.append("<SOAP-ENV:Body>");
        try (StringWriter sw = new StringWriter();
             CompactWriter cw = new CompactWriter((Writer)sw);){
            xstream.marshal(payload, (HierarchicalStreamWriter)cw);
        }
        sb.append(sw.toString());
        sb.append("</SOAP-ENV:Body>");
        sb.append("</SOAP-ENV:Envelope>");
        return sb.toString().getBytes();
    }
}

