/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.xstreamws;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.xstreamws.IBusWsContextKeys;
import com.gridnine.xtrip.server.xstreamws.WsRequest;
import com.gridnine.xtrip.server.xstreamws.WsResponse;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.util.List;

public class XStreamResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsRequest request = (WsRequest)ctx.getMandatoryObject((Enum)IBusWsContextKeys.WS_XSTREAM_REQUEST);
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        this.checkResponse(httpResponse);
        ctx.putObject((Enum)IBusWsContextKeys.WS_XSTREAM_RESPONSE, (Object)this.buildWsResponse(httpResponse, request.getResponseRootClasses()));
    }

    protected void checkResponse(HttpResponse response) {
        if (response.getBody() != null) {
            return;
        }
        if (response.getError() != null) {
            String errorContent = new String(response.getError());
            String fault = this.getSoapTopLevelTagContent(errorContent, "SOAP-ENV:Fault");
            if (fault != null) {
                throw Xeption.forDeveloper((String)"fault: {0}", (Object[])new Object[]{fault});
            }
            throw Xeption.forDeveloper((String)"error: {0}", (Object[])new Object[]{errorContent});
        }
        throw Xeption.forDeveloper((String)"response is null, code = {0}, message = {1}", (Object[])new Object[]{response.getResponseCode(), response.getResponseMessage()});
    }

    private WsResponse buildWsResponse(HttpResponse httpResponse, List<Class> types) {
        WsResponse result = new WsResponse();
        Class[] classes = types.toArray(new Class[types.size()]);
        XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver());
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypes(classes);
        xstream.processAnnotations(classes);
        xstream.ignoreUnknownElements();
        String soapEnvelope = new String(httpResponse.getBody());
        String header = this.getSoapTopLevelTagContent(soapEnvelope, "SOAP-ENV:Header");
        result.getHeaderList().add(xstream.fromXML(header));
        String body = this.getSoapTopLevelTagContent(soapEnvelope, "SOAP-ENV:Body");
        result.setPayload(xstream.fromXML(body));
        return result;
    }

    protected String getSoapTopLevelTagContent(String soapEnvelope, String tag) {
        String lowerEnvelope = soapEnvelope.toLowerCase();
        String start = String.format("<%s>", tag.toLowerCase());
        String end = String.format("</%s>", tag.toLowerCase());
        int bodyStart = lowerEnvelope.indexOf(start);
        int bodyEnd = lowerEnvelope.indexOf(end);
        if (bodyStart == -1 || bodyEnd == -1) {
            return null;
        }
        return soapEnvelope.substring(bodyStart + start.length(), bodyEnd);
    }
}

